﻿Imports System.IO

'This module contains all the constants that are used throughout the entire program, defining tehm here is much easier then in my.settings
'also some routines must be called without hassle, for instance the logfile routine, so therefore these kind of routines are located here as well
Module mod_Constants

    'this program requires a cassiopei with the following firmware version (or higher)
    Public Const fw_vers_required As UInteger = 20160213

    'build date
    '----------
    Public Const BUILD_YEAR As Integer = 16
    Public Const BUILD_MONTH As Integer = 2
    Public Const BUILD_DAY As Integer = 14
    Public Const BUILD_COMMENT As String = "" 'enter additional text here, for example the text: "test version"

    'look-and-feel
    Public Const FFWD_RWD_SPEED = 2511                     'the number of bytes to forward or rewind per FFWD or RWD timer tick
    Public Const CassetteAnimSize = 8                       'the number of frames of the cassette-reel animation
    Public Const CassetteAnimSpeed_play = 150               'the number of milliseconds between each frame
    Public Const CassetteAnimSpeed_wind = 15                'the number of milliseconds between each frame

    'constants
    '---------
    ''these are the PID and the VID of the CPIO device we want to address
    Public Const VID As Integer = &H4D8                     'vendor-ID      (0x04D8 = Microchip's ID, 0x046d = Logitech's ID)
    Public Const PID As Integer = &H2                       'product-ID

    Public Const PACKET_PAYLOADSIZE_DATAFILE As Integer = 58         'we can transmit ... bytes per packet (the absolute max for a HID packet is 64 bytes but this package send a 3 byte address as well creating the extra overhead)
    Public Const PACKET_PAYLOADSIZE_USERFILE As Integer = 63         'we can transmit ... bytes per packet (the absolute max for a HID packet is 64 bytes but we have some overhead)
    Public Const PACKET_PAYLOADSIZE_VIRTUALFILE As Integer = 61      'we can transmit ... bytes per packet (the absolute max for a HID packet is 64 bytes but we have some overhead, especially in the first packet :-(( )

    Public Const BytesPerBlock = 4096 - 4 'a block has 4096 available bytes of which 4 a used by the filesystem (3 bytes for pointing to the next block, plus 1 byte to indicate that it is the first or a following block)
    Public Const BytesPerFileheader = 44            'a fileheader consists of ... bytes that describe the details of the file (name, size, timestamp, etc)

    Public Const CMD_VERSIONINFO As Byte = &H2              'this command is the command required for requesting the version of the cassiopei's firmware
    Public Const CMD_STATUS As Byte = &H3                   'this command is the command required for requesting the status of the TAP file
    Public Const CMD_DISPLAY As Byte = &H4                  'this command can be used to change the text on the OLED display connected to the I2C bus of the Cassiopei
    Public Const CMD_GETREMAININGSPACE As Byte = &H5        'command that requests the real available memory, by counting every free block
    Public Const CMD_SIMULATE_BUTTON_PLAY As Byte = &HA     'this command simulates the pressing of the playbutton on the cassiopei
    'Public Const CMD_PACKAGE_TIMEOUT As Byte = &H12        'indicates that a package has not been received 

    Public Const CMD_PREPARE_FILE_FROM_PC As Byte = &H20    'indicates preparation for transferring a file packet from the PC to this device
    Public Const CMD_FILE_FROM_PC As Byte = &H21            'indicates a file packet from the PC to the device
    Public Const CMD_FILE_FROM_PC_VIRTUALPRGFILE As Byte = &H22 'indicates a file packet from the PC to the device for virtual PRG file transfer purposes
    Public Const CMD_FILE_FROM_PC_VIRTUALTAPFILE As Byte = &H23 'indicates a file packet from the PC to the device for virtual PRG file transfer purposes
    Public Const CMD_VIRTUALTAPTRANSFERSTATUS As Byte = &H24    'indicates the status of the virtual TAP transfer as well as the buffer status

    Public Const CMD_PREPARE_FILE_TO_PC As Byte = &H30      'indicates preparation for transferring a file packet to the PC
    Public Const CMD_FILE_TO_PC As Byte = &H31              'indicates a file packet to the PC

    Public Const CMD_READ_32BYTES_FROM_FLASH As Byte = &H41 'indicates a file packet to the PC
    Public Const CMD_WRITE_DATA_TO_FLASH As Byte = &H42     'indicates a file packet from the PC
    Public Const CMD_READ_DATA_FROM_FLASH As Byte = &H43    'indicates a file packet to the PC

    Public Const CMD_READ_FILE_INFO As Byte = &H51          'request file information for file with index and type
    Public Const CMD_DELETE_CURRENT_FILE As Byte = &H52     'request the deletion of the file that is our current file
    Public Const CMD_READ_CURRENT_FILE As Byte = &H53       'request the reading of the file that is our current file
    Public Const CMD_COUNT_REALSIZE As Byte = &H54          'count the filesize of a file of the given type and index by following the file-chain (usefull to find corrupt files)
    Public Const CMD_FREE_ORPHANED_BLOCKS As Byte = &H55    'release the filesystem from blocks marked as used but are no longer part of any filechain

    Public Const CMD_READ_EEPROM As Byte = &H61             'read from the PIC internal EEPROM (256bytes of EEPROM are available)
    Public Const CMD_WRITE_EEPROM As Byte = &H62            'read from the PIC internal EEPROM (256bytes of EEPROM are available)

    Public Const CMD_TAP_PLAY As Byte = &H72                'start the TAP file playback
    Public Const CMD_TAP_STOP As Byte = &H73                'stops the tape file playback
    Public Const CMD_TAP_POSITION As Byte = &H74            'position the tape file to the desired location (used with FFWD and RWD functions)

    Public Const CMD_DISC_READ_TRACK_SECTOR As Byte = &H81    'this command sends the track and sector to the Cassiopei, where a program needs to run to read it from disk
    Public Const CMD_DISC_GET_BLOCK_DATA As Byte = &H82     'request transfer of the block data

    Public Const CMD_ERASE_ALL_FLASH As Byte = &HF0         'this command will command the device to erase all it's flash
    Public Const CMD_ERASE_BLOCK As Byte = &HF1             'this command will command the device to erase a specified block

    '------------------------------ flash filesystem backup/restore -----------------------------------------------------------
    Public Const FilesystemSize As Long = 8 * 1024 * 1024 '= 8 MByte (takes approx. 800 sec)


    '------------------------------ definitions of CPIO device status ---------------------------------------------------------
    Public Const STATUS_IDLE As Byte = &H0              'the CPIO device is in IDLE state
    Public Const STATUS_REQUESTFILE As Byte = &H10      'request a file from the PC's harddisk

    '------------------------------ definition of file types --------------------------------------------------
    Public Const FILETYPE_UNDEFINED As Byte = &HFF          'undefined filetype
    Public Const FILETYPE_SYS As Byte = &H1                 'SYStem file, contains data to be stored as a continuous (not blocked) file
    Public Const FILETYPE_PRG As Byte = &H2                 'PRoGram file, contains data to be stored using the filesystem (program stored in blocks)
    Public Const FILETYPE_VOC As Byte = &H3                 'VOCabulary file, contains data to be stored using the filesystem (program stored in blocks)
    Public Const FILETYPE_TAP As Byte = &H4                 'TAPe file, contains an sequence of tape signal timings, not data 
    Public Const FILETYPE_WAV As Byte = &H5                 'WAVe file, contains an sequence of samples
    Public Const FILETYPE_DAT As Byte = &H6                 'DATa file contains all sorts of data that might be usefull for a specifc game or program
    '......................................
    Public Const FILETYPE_MENU As Byte = &HE                'this is the program that is used to configure the CPIO device
    Public Const FILETYPE_EEP As Byte = &HF                 'a file used for storing settings of the Cassiopei

    '------------------------------ definition of operating modes --------------------------------------------------
    Public Const OPERATINGMODE_PRG_STANDARDCBM As Byte = &H0
    Public Const OPERATINGMODE_PRG_FASTFLASH As Byte = &H1
    Public Const OPERATINGMODE_PRG_FASTUSB As Byte = &H2
    Public Const OPERATINGMODE_TAP_FLASH As Byte = &H3
    Public Const OPERATINGMODE_TAP_USB As Byte = &H4

    '----------------------------------------------------------------------------------------------------------
    Public ReadOnly ComputerModel_PalNtsc_Definition() As String = {"PAL / 50Hz",
                                                                    "NTSC / 60Hz"}

    Public ReadOnly ComputerModelDefinition() As String = {"Commodore 64",
                                                           "Commodore VIC 20",
                                                           "Commodore Plus4",
                                                           "Commodore C16",
                                                           "Commodore C128",
                                                           "Commodore PET/CBM 20XX (build-in tape drive)",
                                                           "Commodore PET/CBM 20XX & 30XX series",
                                                           "Commodore PET/CBM 40XX series",
                                                           "Commodore PET/CBM 80XX series"}

    '----------------------------------------------------------------------------------------------------------


    'Private ASCII_table() As String = {"NULL", "StartOfHeading", "StartofTeXt", "EndofTeXt", "EndOfTransmission", "ENQuery", "ACKnowledge", "BELL", "Backspace", "HorTab", "LineFeed(\n)", "VerticalTab", "FormFeed", "CarriageReturn(\r)", "ShiftOut", "ShiftIn", "DataLinkEscape", "DeviceControl-1", "DeviceControl-2", "DeviceControl-3", "DeviceControl-4", "NegativeAcKnowledge", "SYNchronousidle", "EndofTransBlock", "CANcel", "EndofMedium", "SUBstite", "ESCape", "FileSeparator", "GroupSeparator", "RecordSeparator", "UnitSeparator",
    '                                   "Space", "!", "double bracket", "#", "$", "%", "&", "single bracket", "(", ")", "*", "+", ",", "-", ".", "/", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ":", ";", "<", "=", ">", "?",
    '                                   "@", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "[", "\", "]", "^", "_",
    '                                   "`", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "{", "|", "}", "~", "DEL",
    '                                   " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ",
    '                                   " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ",
    '                                   " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ",
    '                                   " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " "}

    'the conversion table below has the control characters replaced by the filled square (0x255)
    Public ASCII_table() As String = {"■", "■", "■", "■", "■", "■", "■", "■", "■", "■", "■", "■", "■", "■", "■", "■", "■", "■", "■", "■", "■", "■", "■", "■", "■", "■", "■", "■", "■", "■", "■", "■",
                                       " ", "!", " ", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ":", ";", "<", "=", ">", "?",
                                       "@", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "[", "\", "]", "^", "_",
                                       "`", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "{", "|", "}", "~", "■",
                                       "Ç", "ü", "é", "â", "ä", "à", "å", "ç", "ê", "ë", "è", "ï", "î", "ì", "Ä", "Å", "É", "æ", "Æ", "ô", "ö", "ò", "û", "ù", "ÿ", "Ö", "Ü", "ø", "£", "Ø", "×", "ƒ",
                                       "á", "í", "ó", "ú", "ñ", "Ñ", "ª", "º", "¿", "®", "¬", "½", "¼", "¡", "«", "»", "░", "▒", "▓", "│", "┤", "Á", "Â", "À", "©", "╣", "║", "╗", "╝", "¢", "¥", "┐",
                                       "└", "┴", "┬", "├", "─", "┼", "ã", "Ã", "╚", "╔", "╩", "╦", "╠", "═", "╬", "¤", "ð", "Ð", "Ê", "Ë", "È", "ı", "Í", "Î", "Ï", "┘", "┌", "█", "▄", "¦", "Ì", "▀",
                                       "Ó", "ß", "Ô", "Ò", "õ", "Õ", "µ", "þ", "Þ", "Ú", "Û", "Ù", "ý", "Ý", "¯", "´", "■", "±", "‗", "¾", "¶", "§", "÷", "¸", "°", "¨", "·", "¹", "³", "²", "■", "■"}

    '------------------------------------------------------------------------------------------------------------
    'The OLED display is to be used in a consequent manor, therefor all messages are to be printed on the same line
    Public Const DisplayX As Byte = 0
    Public Const DisplayY As Byte = 5


End Module
