﻿Public Class frm_ProgressBar

    '============ CODE REQUIRED TO PREVENT RESIZING TO MAX SIZE ====================
    'to prevent that this window can be maximized by the user who has a mouse with a maximize window button we require this code
    'this code was found on the internet: http://www.vbdotnetforums.com/windows-forms/21255-how-disable-maximize-fixed-tool-window-form.html

    Declare Function SetWindowPlacement Lib "user32.dll" (ByVal hwnd As Int32, ByRef lpwndpl As WINDOWPLACEMENT) As Int32
    Declare Function GetWindowPlacement Lib "user32.dll" (ByVal hwnd As Int32, ByRef lpwndpl As WINDOWPLACEMENT) As Int32
    Structure WINDOWPLACEMENT
        Public Length As Int32
        Public flags As Int32
        Public showCmd As Int32
        Public ptMinPosition As POINTAPI
        Public ptMaxPosition As POINTAPI
        Public rcNormalPosition As RECT
    End Structure
    Structure POINTAPI
        Public x As Int32
        Public y As Int32
    End Structure
    Structure RECT
        Public Left As Int32
        Public Top As Int32
        Public Right As Int32
        Public Bottom As Int32
    End Structure
    Public Const SW_SHOWMAXIMIZED As Int32 = 3

    Public Const WM_SYSCOMMAND As Integer = &H112
    Public Const SC_MAXIMIZE As Integer = &HF030
    Public Const WM_GETMINMAXINFO As Int32 = &H24
    Structure MINMAXINFO
        Public ptReserved As POINTAPI
        Public ptMaxSize As POINTAPI
        Public ptMaxPosition As POINTAPI
        Public ptMinTrackSize As POINTAPI
        Public ptMaxTrackSize As POINTAPI
    End Structure

    Protected Overloads Overrides Sub WndProc(ByRef m As Message)
        If m.Msg = WM_SYSCOMMAND AndAlso m.WParam.ToInt32() = SC_MAXIMIZE Then
            Return
        ElseIf m.Msg = WM_GETMINMAXINFO Then
            Dim mm As MINMAXINFO = Runtime.InteropServices.Marshal.PtrToStructure(m.LParam, GetType(MINMAXINFO))
            mm.ptMaxSize.x = Me.Width
            mm.ptMaxSize.y = Me.Height
            mm.ptMaxPosition.x = Me.Location.X
            mm.ptMaxPosition.y = Me.Location.Y
            Runtime.InteropServices.Marshal.StructureToPtr(mm, m.LParam, True)
        End If
        MyBase.WndProc(m)
    End Sub

    '======================================================================================



    Public Sub Init(ByVal text As String, ByVal min As Double, ByVal max As Double)
        Me.Text = text
        ProgressBar1.Minimum = min
        ProgressBar1.Value = min
        ProgressBar1.Maximum = max
    End Sub

    Public Sub Value(ByVal val As Double)
        If (val > ProgressBar1.Maximum) Then
            Debug.Print("Progressbar input value (" & val & ")too large, clamping to max (" & ProgressBar1.Maximum & ")")
        Else
            ProgressBar1.Value = val
            ProgressBar1.PerformStep()      'required for windows 7 and 8.1 (or higher?)
            'Performstep is required because windows 7 and 8.1 use an animated progressbar (animations are associated with your desktop settings).
            'Progressbar1.PerformStep, is the preferred way to update the Value property WITHOUT using the animations feature.

        End If
    End Sub

End Class