﻿'todo: cls_Cassiopei uses progressbar1 (which is defined in frm_main, this is dirty programming, this needs to be cleaned up by using a pop-up (this was done this way in order to continu with the real problem, transfer of the data)

Imports System.IO
Imports System.Diagnostics

Public Class frm_Main

    'Public clsCompress As New cls_Compress              'we use this class to make things smaller
    Private stopWatch As New Stopwatch()

    Private int_original_window_size As Integer
    Private str_arr_FilesInFolder() As String
    Private int_number_of_files_in_folder As Integer
    Private str_EntryInFolder As String

    Private input_filepath As String
    Private input_filename As String
    Private input_filesize As Integer
    Private FreeSpaceOnCassiopei As Integer

    Private DeleteButtonState As Boolean
    Private ExtractButtonState As Boolean

    Private USB_device_available As Boolean = False

    Private VirtualTapCounter As UInteger = 0
    Private VirtualTapMode As Integer = VirtualTapModes.idle

    Enum VirtualTapModes As Integer
        idle
        play
        forward
        rewind
    End Enum

    Private FlashTapMode As Integer
    Enum FlashTapModes As Integer
        idle
        play
        forward
        rewind
        status
    End Enum

    'the columns in the filemanager have the following order, do not change this without changing the text in the listview of the filemanager tab.
    Enum FileManagerColumn As Integer
        name 'column of listview that holds the name
        firstadr 'column of listview that holds the file's first address (aka LOAD address)
        lastadr 'column of listview that holds the file's last address
        expsize 'column of listview that holds the expected size (the size as stored in the file info, this may differ from the real size, which is determenind by following the filechain)
        compmodel
        type 'column of listview that holds the file type
        index 'column of listview that holds the index
        datestamp
        timestamp
        firstblock
        realfilesize
        numberofitems   'a simple indicator which we can use to see how many enum values we have (this is used to determenine how many rtemnp string we should create when building the listview)
    End Enum

    '----------------------------------- classes --------------------------------------------------------------

    Public clsUSB As New cls_USB_Cassiopei              'the USB-IO 
    Public clsTAP As New cls_TAP_file                   'the TAP file details

    '----------------------------------------------------------------------------------------------------------

    'the routine below will be executed when the program starts
    Private Sub frm_Main_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        'get settings from config file
        chk_RequestComputermodel.Checked = My.Settings.boo_RequestCompmodel
        chk_ShowFilesForAllComputermodels.Checked = My.Settings.boo_Showallfiles
        chk_CompressTapFiles.Checked = My.Settings.boo_CompressionEnabled
        If (chk_CompressTapFiles.Checked = False) Then
            If MessageBox.Show("TAP file compression has been disabled." & vbCrLf &
                               "It is suggested to enable this option in" & vbCrLf &
                               "order to save flash memory space. This" & vbCrLf &
                               "will allow you to store more files onto" & vbCrLf &
                               "the Cassiopei flash filesystem." & vbCrLf & vbCrLf &
                               "Do you want to enable this option?" & vbCrLf &
                               "(this does not affect already stored files)",
                               "Use TAP file compression", MessageBoxButtons.YesNo, MessageBoxIcon.Question) = DialogResult.Yes Then
                chk_CompressTapFiles.Checked = True
            End If
        End If

        'initialize combobox(es)
        cmb_SettingComputerModel.Items.Clear() 'remove items (if present)
        For Each element As String In ComputerModelDefinition 'use values as defined in the constants definitions
            cmb_SettingComputerModel.Items.Add(element)
        Next

        cmb_SettingComputerModel_PalNtsc.Items.Clear() 'remove items (if present)
        For Each element As String In ComputerModel_PalNtsc_Definition 'use values as defined in the constants definitions
            cmb_SettingComputerModel_PalNtsc.Items.Add(element)
        Next

        'version indicator
        txt_VersionInfoCassiopeiManager.Text = " 20" & BUILD_YEAR.ToString("D2") & BUILD_MONTH.ToString("D2") & BUILD_DAY.ToString("D2") & " " & BUILD_COMMENT
        USB_device_available = clsUSB.Initialize()

        'check if device is present
        If (USB_device_available = False) Then
            If MessageBox.Show("The Cassiopei could not be detected. All functionality will" & vbCrLf &
                               "be disabled. In order to continue, close this application and" & vbCrLf &
                               "try one or more of the suggested solutions:" & vbCrLf &
                               vbCrLf &
                               "- Check if the USB-IO device is connected to the computer" & vbCrLf &
                               "- Check if the USB cable is inserted properly" & vbCrLf &
                               "- Press the Cassiopei reset button and wait 5 seconds" & vbCrLf &
                               "- The CBM could also be keeping the Cassiopei device busy" & vbCrLf &
                               "  in that case the CBM computer must be also be resetted." & vbCrLf &
                               "  Press the computers reset button or switch it off and on." & vbCrLf &
                               vbCrLf &
                               "Do you want to close this application?",
                               "Cassiopei not detected", MessageBoxButtons.YesNo, MessageBoxIcon.Question) = DialogResult.Yes Then
                Me.Close()
            End If
        End If

        'command line options are useful for people who want to couple the virtual file mode to their development setup
        'when the press the compile button of their development suite, it (if configured properly) will automatically start
        'a virtual file transfer, saving them time.

        '....Cassiopei_manager.exe /v d:\test.prg
        'the commandline will be broken into sperate pieces using the space as the separator character
        'then: Environment.GetCommandLineArgs(1) will contain "/v"
        '      Environment.GetCommandLineArgs(2) will contain "d:\test.prg"

        If Environment.GetCommandLineArgs.Count >= 2 Then
            If Environment.GetCommandLineArgs(1) = "/v" Then
                Me.WindowState = FormWindowState.Minimized  'Minimize program window, it will close soon anyaway, so making it visible will only cause confusion
                Dim pgrBar As New frm_ProgressBar           'when the Simulate_button_Play command is given, the cassiopei will not respond for a few seconds
                Dim virtualfilename As String = Environment.GetCommandLineArgs(2)

                'transfer virtual file
                'MsgBox(virtualfilename)

                pgrBar.Init("Preparing transfer", 0, 2)     'to indicate action, a dummy progressbar is shown with the text "preparing transfer"
                pgrBar.Value(1)
                pgrBar.Show()
                Application.DoEvents()                      'update the GUI!!!
                clsUSB.Simulate_Button_Play()               'simulate a play-button press on the Cassiopei
                pgrBar.Dispose()                            'the dummy progressbar is no longer needed

                clsUSB.Send_Virtual_PRG_File(virtualfilename) 'transfer file contents

                System.Threading.Thread.Sleep(1000)

                Me.Close()                                  'close application

            End If
        End If




        tmr_Startup.Interval = 1000 'communicate with Cassiopei ... mSec after USB init
        tmr_Startup.Enabled = True

        Buttons_Disable()
        cmb_numberofbytes.SelectedIndex = 0

        int_original_window_size = Me.Size.Width 'save screensize, so the program looks the way it was the last time you used it
        txt_VirtualPrgFile.Text = My.Settings.str_UsedVirtualPrgFile
        txt_VirtualTapFile.Text = My.Settings.str_UsedVirtualTapFile

        ListView.SelectedItems.Clear()    'clear the listview
        ListView.Columns.Add("Filename", 250, HorizontalAlignment.Left)
        ListView.Columns.Add("First adr.", 60, HorizontalAlignment.Center)
        ListView.Columns.Add("Last adr.", 60, HorizontalAlignment.Center)
        ListView.Columns.Add("Size", 60, HorizontalAlignment.Center)
        ListView.Columns.Add("Computer model", 200, HorizontalAlignment.Left)
        ListView.Columns.Add("Filetype", 150, HorizontalAlignment.Left)
        ListView.Columns.Add("Index", 50, HorizontalAlignment.Center)
        ListView.Columns.Add("Date", 100, HorizontalAlignment.Center)
        ListView.Columns.Add("Time", 60, HorizontalAlignment.Center)
        ListView.Columns.Add("Flash memory addr.", 100, HorizontalAlignment.Left)
        ListView.Columns.Add("Real size", 100, HorizontalAlignment.Left)

    End Sub

    'this timer is to be programmed to start after 1 second after load,
    'some routines cannot be loaded directly after start and that why this delay is used
    Private Sub tmr_Startup_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tmr_Startup.Tick
        tmr_Startup.Enabled = False                             'disable time, we do not longer need it, the task below only need to be executed once
        If (USB_device_available = True) Then                   'when CPIO device is available
            txt_VersionInfoCassiopei.Text = clsUSB.GetVersionInfo()    'fill the version textbox
            If (Val(txt_VersionInfoCassiopei.Text) < fw_vers_required) Then
                MessageBox.Show("The Cassiopei has firmware version: " & txt_VersionInfoCassiopei.Text & "." & vbCrLf &
                                "This is an old version that is not supported" & vbCrLf &
                                "by this version of the Cassiopei manager." & vbCrLf & vbCrLf &
                                "In order to continue you must update the" & vbCrLf &
                                "Cassiopei to firmware version " & fw_vers_required & " (or higher)." & vbCrLf & vbCrLf &
                                "For firmware updates and instructions see the website: http://home.kpn.nl/bderogee1980 ",
                                "Firmware update required", MessageBoxButtons.OK, MessageBoxIcon.Stop)
            Else
                'everything checks out fine, so we may enable all functions of the program
                Read_Flash_Directory()                              'load the contents of the flash chip (a.k.a. directory) and EEPROM settings
                Buttons_Enable()                                    'enable functionality of program
            End If
        End If
    End Sub

    Private Sub frm_Main_formclosed(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.FormClosed
        My.Settings.boo_RequestCompmodel = chk_RequestComputermodel.Checked
        My.Settings.boo_Showallfiles = chk_ShowFilesForAllComputermodels.Checked
        My.Settings.boo_CompressionEnabled = chk_CompressTapFiles.Checked
        My.Settings.Save() 'save settings on exit...
    End Sub

    Public Function GetFilesizeSize(ByVal filename As String) As Double
        Return New IO.FileInfo(filename).Length
    End Function

    Private Sub Buttons_Disable()
        ListView.Enabled = False
        DeleteButtonState = btn_DeleteFile.Enabled    'save the state (we do not want to enabled the button later on while it wasn't enabled before
        btn_DeleteFile.Enabled = False
        btn_AddMenuFile.Enabled = False
        btn_AddPlayFile.Enabled = False
        btn_AddDataFile.Enabled = False
        btn_Directory.Enabled = False
        btn_ReadFlash.Enabled = False
        btn_BackupFlashFilesystem.Enabled = False
        btn_RestoreFlashFilesystem.Enabled = False
        btn_CheckFilesystem.Enabled = False
        btn_EraseAllFlash.Enabled = False
        btn_Settings.Enabled = False
        btn_WriteSettingsToEEPROM.Enabled = False

        btn_SelectVirtual_PRG_File.Enabled = False
        btn_SendVirtual_PRG_File.Enabled = False

        btn_SelectVirtual_TAP_File.Enabled = False
        btn_SendVirtual_TAP_File.Enabled = False

        btn_TAPStatus.Enabled = False
        btn_TAPPlay.Enabled = False
        btn_TAPPlay_2.Enabled = False
        btn_TAPRewind.Enabled = False
        btn_TAPRewind_2.Enabled = False
        btn_TAPForward.Enabled = False
        btn_TAPForward_2.Enabled = False
        trk_TAPfile.Enabled = False


        Select Case (cmb_SettingFileMode.SelectedIndex)
            Case OPERATINGMODE_TAP_FLASH
                btn_TAPStop.Enabled = True
                btn_TAPStop_2.Enabled = True

            Case OPERATINGMODE_TAP_USB
                btn_TAPStop.Enabled = True
                btn_TAPStop_2.Enabled = True

            Case Else
                btn_TAPStop.Enabled = False
                btn_TAPStop_2.Enabled = False
        End Select

    End Sub

    Private Sub Buttons_Enable()
        ListView.Enabled = True
        btn_DeleteFile.Enabled = DeleteButtonState
        btn_AddMenuFile.Enabled = True
        btn_AddPlayFile.Enabled = True
        btn_AddDataFile.Enabled = True
        btn_Directory.Enabled = True
        btn_ReadFlash.Enabled = True
        btn_BackupFlashFilesystem.Enabled = True
        btn_RestoreFlashFilesystem.Enabled = True
        btn_CheckFilesystem.Enabled = True
        btn_EraseAllFlash.Enabled = True
        btn_Settings.Enabled = True
        btn_WriteSettingsToEEPROM.Enabled = True

        Select Case (cmb_SettingFileMode.SelectedIndex)
            'Case OPERATINGMODE_PRG_STANDARDCBM

            'Case OPERATINGMODE_PRG_FASTFLASH

            Case OPERATINGMODE_PRG_FASTUSB                  'only when the virtual filemode has been selected, the corresponding button will be enabled
                btn_SelectVirtual_PRG_File.Enabled = True
                btn_SendVirtual_PRG_File.Enabled = True

            Case OPERATINGMODE_TAP_FLASH                    'only when the virtual filemode has been selected, the corresponding button will be enabled
                btn_TAPStatus.Enabled = True
                btn_TAPPlay.Enabled = True
                btn_TAPPlay_2.Enabled = True
                btn_TAPRewind.Enabled = True
                btn_TAPRewind_2.Enabled = True
                btn_TAPForward.Enabled = True
                btn_TAPForward_2.Enabled = True
                trk_TAPfile.Enabled = True
                btn_TAPStop.Enabled = False
                btn_TAPStop_2.Enabled = False

            Case OPERATINGMODE_TAP_USB
                If (VirtualTapMode = VirtualTapModes.idle) Then
                    btn_SelectVirtual_TAP_File.Enabled = True
                    btn_SendVirtual_TAP_File.Enabled = True
                End If

                btn_TAPPlay.Enabled = True
                btn_TAPPlay_2.Enabled = True
                btn_TAPRewind.Enabled = True
                btn_TAPRewind_2.Enabled = True
                btn_TAPForward.Enabled = True
                btn_TAPForward_2.Enabled = True
                trk_TAPfile.Enabled = True
                btn_TAPStop.Enabled = False
                btn_TAPStop_2.Enabled = False
        End Select

    End Sub

    '****************************************************************************************************************************************************
    'File manager related functions *********************************************************************************************************************
    '****************************************************************************************************************************************************

    Private Sub btn_ReadDirAndSettings_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_Directory.Click, btn_Settings.Click
        Read_Flash_Directory()
    End Sub

    'this routine will display the file names of the files stored on the flash memory of the CPIO device
    Private Sub Read_Flash_Directory()
        Const maxblocks = 2048 '8MByte flash memory (the standard and only amount of flash memory on a Cassiopei)
        Dim calc_used_blocks As Integer
        Dim real_free_blocks As Integer

        Buttons_Disable()

        'send a message to the display, if this does not respond, then we shoudl not attempt to read the dir, because that most likely will also fail
        If (clsUSB.Display(DisplayX, DisplayY, "  Reading directory  ") = False) Then
            Buttons_Enable()
            Exit Sub
        End If

        Dim pgrBar As New frm_ProgressBar
        pgrBar.Init("Accessing Cassiopei, please wait", 0, 10)
        pgrBar.Value(10)
        pgrBar.Show()
        Application.DoEvents()      'update the GUI!!!

        ReadEEPROMContents()

        ListView.Items.Clear()   'clear listbox
        calc_used_blocks = Read_Dir(FILETYPE_SYS, Color.Black)                     'show all system files that are stored on flash
        calc_used_blocks = calc_used_blocks + Read_Dir(FILETYPE_VOC, Color.Black)  'show all vocabulary files that are stored on flash
        If (chk_ShowFilesForAllComputermodels.Checked = True) Then
            For CMODEL = 0 To (ComputerModelDefinition.Length - 1)  'loop through all the possible computer models
                calc_used_blocks = calc_used_blocks + Read_Dir(((CMODEL * 16) + FILETYPE_MENU), Color.Black) 'show all boot files that are stored on flash
                calc_used_blocks = calc_used_blocks + Read_Dir(((CMODEL * 16) + FILETYPE_PRG), Color.Black)  'show all files of this type stored on flash
                calc_used_blocks = calc_used_blocks + Read_Dir(((CMODEL * 16) + FILETYPE_TAP), Color.Black)  'show all files of this type stored on flash
            Next
        Else
            calc_used_blocks = calc_used_blocks + Read_Dir(((cmb_SettingComputerModel.SelectedIndex * 16) + FILETYPE_MENU), Color.Black) 'show all boot files that are stored on flash
            calc_used_blocks = calc_used_blocks + Read_Dir(((cmb_SettingComputerModel.SelectedIndex * 16) + FILETYPE_PRG), Color.Black)  'show all files of this type stored on flash
            calc_used_blocks = calc_used_blocks + Read_Dir(((cmb_SettingComputerModel.SelectedIndex * 16) + FILETYPE_TAP), Color.Black)  'show all files of this type stored on flash
        End If

        calc_used_blocks = calc_used_blocks + Read_Dir(FILETYPE_WAV, Color.Black)  'show all files of this type stored on flash
        calc_used_blocks = calc_used_blocks + Read_Dir(FILETYPE_DAT, Color.Black)  'show all files of this type stored on flash
        calc_used_blocks = calc_used_blocks + Read_Dir(FILETYPE_EEP, Color.Gray)   'show all files of this type stored on flash

        real_free_blocks = clsUSB.Read_RemaningSpace()
        FreeSpaceOnCassiopei = real_free_blocks * 4096 'free space on flash memory of Cassiopei in bytes
        txt_Status.Text = ListView.Items.Count & " files found, free space = " & real_free_blocks & " blocks or " & FreeSpaceOnCassiopei & " Bytes"

        If (chk_ShowFilesForAllComputermodels.Checked = True) Then 'a sanity check is only possible if we've read the entire filesystem
            If ((maxblocks - calc_used_blocks) = real_free_blocks) Then
                txt_Status.Text = txt_Status.Text & vbCrLf & "Filesystem status OK"
            Else
                txt_Status.Text = txt_Status.Text & vbCrLf & "ATTENTION: check filesystem (calc=" & (maxblocks - calc_used_blocks) & ", real=" & real_free_blocks & ")"
            End If
        Else
            txt_Status.Text = txt_Status.Text & vbCrLf & "Filesystem status unknown"
        End If

        'send a message to the display, if this does not respond, then we shoudl not attempt to read the dir, because that most likely will also fail
        clsUSB.DisplayClearline(DisplayX, DisplayY)
        pgrBar.Dispose()
        Buttons_Enable()
    End Sub

    'read the directory entry of filetype... and return the number of blocks used by all these files
    Private Function Read_Dir(ByVal filetype As Byte, ByVal col As Color) As Integer
        Dim lp As Byte
        Dim result As Boolean
        Dim index As Integer = 0
        Dim used_blocks As Integer = 0

        'Debug.Print("searching for filetype:" & filetype.ToString)

        If (cmb_SettingFileMode.SelectedIndex <> OPERATINGMODE_TAP_FLASH) Then
            txt_TAPfilename.Text = "The Cassiopei is not set into TAP from Flash file playback mode"
            lbl_tapecnt_max.Text = "0"
        End If

        Try
            used_blocks = 0
            'we only scan for max 255 files(of the given type) (which is more then possible)
            For lp = 0 To 255
                If lp = 0 Then
                    result = clsUSB.Read_FileInfo(0, filetype)   'search for first file (the flag indicating the computertype will be ignored)
                Else
                    result = clsUSB.Read_FileInfo(1, filetype)   'search for next file (the flag indicating the computertype will be ignored)
                End If

                If (result = False) Then
                    Exit For 'there was no more information found, so we may exit the loop
                Else
                    'when the file info is not empty and the TAP file mode currently used, then update the textbox of the TAP file screen
                    If ((cmb_SettingFileMode.SelectedIndex = OPERATINGMODE_TAP_FLASH) And ((filetype And &HF) = FILETYPE_TAP) And (cmb_SettingFileIndex.SelectedIndex = lp) And (((filetype And &HF0) >> 4) = cmb_SettingComputerModel.SelectedIndex)) Then
                        txt_TAPfilename.Text = clsUSB.FileInfo_Name
                        If (clsUSB.FileInfo_RealSize > 0) Then  'in case of an uncompressed file the uncompressed size = 0
                            trk_TAPfile.Maximum = Val(clsUSB.FileInfo_RealSize)
                        Else
                            trk_TAPfile.Maximum = clsUSB.FileInfo_BlockSize * BytesPerBlock
                        End If
                        lbl_tapecnt_max.Text = trk_TAPfile.Maximum
                    End If


                    'add data to the listview (file manager)
                    Dim str(FileManagerColumn.numberofitems) As String
                    Dim itm As ListViewItem
                    str(FileManagerColumn.index) = lp
                    str(FileManagerColumn.name) = clsUSB.FileInfo_Name
                    str(FileManagerColumn.firstadr) = clsUSB.FileInfo_AdrFirst
                    str(FileManagerColumn.lastadr) = clsUSB.FileInfo_AdrLast
                    str(FileManagerColumn.expsize) = clsUSB.FileInfo_BlockSize.ToString("D4")
                    str(FileManagerColumn.type) = clsUSB.FileInfo_Type

                    Try
                        If (((filetype And &HF) = FILETYPE_MENU) Or ((filetype And &HF) = FILETYPE_PRG) Or ((filetype And &HF) = FILETYPE_TAP)) Then
                            'str(FileManagerColumn.compmodel) = clsUSB.FileInfo_CompModel       'show the number of the computermodel
                            str(FileManagerColumn.compmodel) = clsUSB.FileInfo_CompModel.ToString("d2") & ":" & ComputerModelDefinition(clsUSB.FileInfo_CompModel)
                        Else
                            str(FileManagerColumn.compmodel) = "-N/A-"
                        End If

                    Catch ex As Exception
                        str(FileManagerColumn.compmodel) = "- error -"   'we need to display something if there is an unexpected problem
                    End Try

                    str(FileManagerColumn.datestamp) = clsUSB.FileInfo_Date
                    str(FileManagerColumn.timestamp) = clsUSB.FileInfo_Time
                    str(FileManagerColumn.firstblock) = clsUSB.FileInfo_FirstBlock
                    str(FileManagerColumn.realfilesize) = clsUSB.FileInfo_RealSize
                    itm = New ListViewItem(str)
                    itm.ForeColor = col

                    'the file that is currently selected must be indicated by a different backcolor
                    If (((filetype And &HF) = FILETYPE_PRG) And ((cmb_SettingFileMode.SelectedIndex = 0) Or (cmb_SettingFileMode.SelectedIndex = 1)) And (((filetype And &HF0) >> 4) = cmb_SettingComputerModel.SelectedIndex)) Then
                        If (Val(cmb_SettingFileIndex.SelectedItem) = lp) Then
                            itm.BackColor = Color.LightGray
                        End If
                    End If

                    If ((((filetype And &HF) = FILETYPE_TAP) And (cmb_SettingFileMode.SelectedIndex = 3)) And (((filetype And &HF0) >> 4) = cmb_SettingComputerModel.SelectedIndex)) Then
                        If (Val(cmb_SettingFileIndex.SelectedItem) = lp) Then
                            itm.BackColor = Color.LightGray
                        End If
                    End If

                    ListView.Items.Add(itm)

                    index = index + 1
                    used_blocks = used_blocks + clsUSB.FileInfo_BlockSize
                End If
                '  ListView.Refresh()  'disabled because it simply is anoying when you have a large number of files on the flash memory
            Next lp

        Catch ex As Exception
            MsgBox("Problem retrieving file information from CPIO device")
        End Try

        Read_Dir = used_blocks

        'for a nicer screenlayout, it is usefull to add an empty line, but only if there was any information added in this pass, fortunately if that is the case then the used_blocks counter will be graeter then 0
        ''''If ((add_empty_line = True) And (used_blocks > 0)) Then ListView.Items.Add("--") 'add a simple separator for visual apeal (but only if required)
    End Function

    'perform a filesystem check, by comparing the filesize-value and the real filesize measured by counting the blocks
    Private Sub btn_CheckFilesystem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_CheckFilesystem.Click
        Dim realsize As Integer
        Dim expectedsize As Integer
        Dim corruptfilecount As Integer
        Dim old_chk_ShowFilesForAllComputermodels As Boolean

        old_chk_ShowFilesForAllComputermodels = chk_ShowFilesForAllComputermodels.Checked   'save checkbox/flag because we could be changing it for the following test

        chk_ShowFilesForAllComputermodels.Checked = True    'filesystem check is only possible if all files are read
        Read_Flash_Directory()                              'before we start we must make sure that we are working with all AND the latest info, so refresh the listview items by doing a dir read

        clsUSB.Display(DisplayX, DisplayY, "    Scanning files   ")
        corruptfilecount = 0
        Dim lvi As ListViewItem
        For Each lvi In ListView.Items
            expectedsize = Val(lvi.SubItems(FileManagerColumn.expsize).Text)

            'old: the line below was causing the wrong files to be marked as corrupt because it did not correct for the computermodel, there it used always the C64 file and most of the time the size of a c64 file does not match the size of a vic20 file
            'realsize = clsUSB.RealFileSize(Val(lvi.SubItems(FileManagerColumn.index).Text), Val(lvi.SubItems(FileManagerColumn.type).Text))  'the fileindex and the type are stored in the .. column of the listview

            'new: the line below is the fixed version
            realsize = clsUSB.RealFileSize(Val(lvi.SubItems(FileManagerColumn.index).Text), ((Val(lvi.SubItems(FileManagerColumn.compmodel).Text) << 4) + Val(lvi.SubItems(FileManagerColumn.type).Text)))  'the fileindex and the type are stored in the .. column of the listview

            If (expectedsize <> realsize) Then
                'MsgBox("The file:" & lvi.SubItems(col_name).Text & " has an incorrect length, delete this file to solve the problem")
                lvi.ForeColor = Color.Red
                lvi.SubItems(FileManagerColumn.expsize).Text = "exp=" & expectedsize & ",real=" & realsize
                corruptfilecount = corruptfilecount + 1 'corrupt file found, increment counter
            End If
        Next

        'when no corrupted files could been found there is only one explanation, there are files marked as being used while in fact they are no longer connected to a file
        If (corruptfilecount = 0) Then
            clsUSB.DisplayClearline(DisplayX, DisplayY)
            clsUSB.CheckFilechains()
            clsUSB.Display(DisplayX, DisplayY, "   Scanning blocks   ")
        Else
            MessageBox.Show("Corrupt files found, these files are marked with a red color in the" & vbCrLf &
                            "filemanager window. Scroll through the list of files and manually" & vbCrLf &
                            "delete these files in order to solve the problem." & vbCrLf &
                            "in order to solve the problem.", "Check filesystem", MessageBoxButtons.OK)
            TabControl.SelectedIndex = 0    'swith to the filemanager tab
        End If

        chk_ShowFilesForAllComputermodels.Checked = old_chk_ShowFilesForAllComputermodels   'restore the status of the checkbox/flag
    End Sub

    Private Sub btn_AddPlayFile_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_AddPlayFile.Click
        Buttons_Disable()
        OpenFileDialog.ValidateNames = False
        OpenFileDialog.FileName = ""
        OpenFileDialog.Filter = "Programs and games (*.PRG)|*.PRG|TAPe emulation (*.TAP)|*.TAP"
        OpenFileDialog.Multiselect = True 'allow user to select more then one file to be added, this minimizes the mouse clicks when configuring your system

        If (OpenFileDialog.ShowDialog = Windows.Forms.DialogResult.OK) Then
            Dim file As String
            For Each file In OpenFileDialog.FileNames
                Debug.Print("Processing:" & file & ", size=" & GetFilesizeSize(file) & "bytes")
                If (Addfile(file, False) = False) Then
                    Read_Flash_Directory()  'update the directory window
                    Buttons_Enable()
                    Exit Sub
                End If
            Next
        End If

        Read_Flash_Directory()  'update the directory window
        Buttons_Enable()
    End Sub

    Private Sub btn_AddMenuFile_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_AddMenuFile.Click
        Buttons_Disable()
        OpenFileDialog.ValidateNames = False
        OpenFileDialog.FileName = ""
        OpenFileDialog.Filter = "Programs and games (*.PRG)|*.PRG"

        If (OpenFileDialog.ShowDialog = Windows.Forms.DialogResult.OK) Then
            If (Addfile(OpenFileDialog.FileName, True) = False) Then
                Read_Flash_Directory()  'update the directory window
                Buttons_Enable()
                Exit Sub
            End If
        End If

        Read_Flash_Directory()  'update the directory window
        Buttons_Enable()
    End Sub

    Private Sub btn_AddDataFile_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_AddDataFile.Click
        Buttons_Disable()
        OpenFileDialog.ValidateNames = False
        OpenFileDialog.FileName = ""
        'OpenFileDialog.Filter = "WAVe audio (*.WAV)|*.WAV|DATa file (*.DAT)|*.DAT|Vocabulary (*.VOC)|*.VOC|System (*.SYS)|*.SYS"
        OpenFileDialog.Filter = "WAVe audio (*.WAV)|*.WAV|DATa file (*.DAT)|*.DAT|Vocabulary (*.VOC)|*.VOC|System (*.SYS)|*.SYS|Disk Image(*.D64)|*.D64"
        OpenFileDialog.Multiselect = True 'allow user to select more then one file to be added, this minimizes the mouse clicks when configuring your system

        If (OpenFileDialog.ShowDialog = Windows.Forms.DialogResult.OK) Then
            Dim file As String
            For Each file In OpenFileDialog.FileNames
                Debug.Print("Processing:" & file & ", size=" & GetFilesizeSize(file) & "bytes")
                If (Addfile(file, False) = False) Then
                    Read_Flash_Directory()  'update the directory window
                    Buttons_Enable()
                    Exit Sub
                End If
            Next
        End If

        Read_Flash_Directory()  'update the directory window
        Buttons_Enable()
    End Sub


    'this routine will add a file to the CPIO's filesystem
    'the flag "MenuFile" indicates whether this file should be stored for use as a Menu-button file (the file that is loaded when pressing the menu button)
    Private Function Addfile(ByVal filepath As String, ByVal MenuFile As Boolean) As Boolean
        Dim extension As String
        Dim starttime As Long
        Dim endtime As Long
        Dim duration As Long
        Dim transferrate As Integer
        Dim compmodelflag As Byte

        If FreeSpaceOnCassiopei < GetFilesizeSize(filepath) Then
            Debug.Print("Size of selected file exceeds free space on Cassiopei's flash memory")
            MessageBox.Show("The Cassiopei has not enough flash available to store the file." & vbCrLf & "Filesize: " & GetFilesizeSize(OpenFileDialog.FileName) & " bytes, available space: " & FreeSpaceOnCassiopei & " bytes", "File transfer failed", MessageBoxButtons.OK, MessageBoxIcon.Error)
            Addfile = False 'it does not fit, no reason to continue...
            Exit Function
        Else
            'check which filetype we are dealing with
            extension = Path.GetExtension(filepath).ToUpper  'get file extension and make it uppercase
            Debug.Print("extension=" & extension)

            'request computer model (but only for the filetypes that require it and only if the user has configured the Cassiopei manager for asking for it)
            If (extension = ".PRG") Or (extension = ".TAP") Or (extension = ".VOC") Then
                If ((MenuFile = True) Or (chk_RequestComputermodel.Checked = True)) Then 'always ask computermodel for menufiles
                    Dim dialog As New dia_ComputerModel
                    dialog.SetFilename(filepath)
                    If dialog.ShowDialog() = DialogResult.OK Then
                        'Debug.Print("dialog.CompModel=" + dialog.CompModel.ToString)
                        compmodelflag = dialog.CompModel
                    Else
                        Addfile = False 'user pressed cancel, so if the user is not able to make this simple choice, then we do nothing also...
                        Exit Function
                    End If
                Else
                    compmodelflag = CByte(cmb_SettingComputerModel.SelectedIndex)
                End If
            End If

            Select Case extension
                Case ".SYS"
                    Debug.Print("Systemfile detected")
                    'check if the flash is completely empty (no user files entries, number of listbox items=0)
                    Read_Flash_Directory() 'get the latest status of the contents of the flash chip
                    If (ListView.Items.Count > 0) Then
                        If MessageBox.Show("The flash chip of the CPIO device is not empty?" & vbCrLf & vbCrLf & "Adding a system file requires the flash chip to be completely empty" & vbCr & vbLf & "Are you sure you want to erase the flash chip and add a system file?", "Erase flash chip and add system file", MessageBoxButtons.YesNo, MessageBoxIcon.Question) = DialogResult.Yes Then
                            Debug.Print("user want to continue")
                        Else
                            Debug.Print("User cancelled transfer of system file")
                            Addfile = False 'user pressed cancel
                            Exit Function
                        End If
                    End If

                    clsUSB.EraseAllFlash()    'ok, yo asked for it, flash chip will be erased...
                    Try 'the selected systemfile will be send to slave device
                        Debug.Print("start transfer of system file")
                        starttime = TimeOfDay.Ticks
                        clsUSB.Send_data_File(filepath, 0, 0, 0) 'this is filetype &H2, but there is no need to send this parameter as it is allready in the file
                        Debug.Print("transfer of system file finished")
                        Addfile = False 'even if it succeeds, we only want to load 1 of this type of file into the cassiopei
                    Catch ex As Exception
                        MsgBox("System file transfer error")
                    End Try

                Case ".PRG"
                    Debug.Print("User file (type PRoGram) detected")
                    Try 'the selected userfile will be send to slave device
                        If (MenuFile = True) Then
                            If (clsUSB.Read_FileInfo(0, ((compmodelflag << 4) + FILETYPE_MENU)) = True) Then      'check if there are already files indicated as boot file for this computermodel
                                MessageBox.Show("There is already a menu program installed for the selected computermodel. Please remove the other file first or select a different computermodel.", "Multiple menu programs for the same model?", MessageBoxButtons.OK, MessageBoxIcon.Information)
                                Addfile = False
                                Exit Function
                            Else
                                starttime = TimeOfDay.Ticks
                                clsUSB.Send_user_File(filepath, ((compmodelflag << 4) + FILETYPE_MENU)) 'add the menu file
                                Addfile = True
                            End If
                        Else
                            starttime = TimeOfDay.Ticks
                            clsUSB.Send_user_File(filepath, ((compmodelflag << 4) + FILETYPE_PRG)) 'add the file
                            Addfile = True
                        End If

                    Catch ex As Exception
                        MsgBox("User file transfer error")
                    End Try

                Case ".TAP"
                    Debug.Print("Tape emulation file (type TAPe) detected")
                    Try 'the selected userfile will be send to slave device                       
                        starttime = TimeOfDay.Ticks
                        clsUSB.Send_TAP_File(filepath, ((compmodelflag << 4) + FILETYPE_TAP), chk_CompressTapFiles.Checked)
                        Addfile = True
                    Catch ex As Exception
                        MsgBox("User file transfer error")
                    End Try

                Case ".VOC"
                    Debug.Print("User file (type VOCabulary) detected")
                    Try 'the selected userfile will be send to slave device
                        starttime = TimeOfDay.Ticks
                        clsUSB.Send_user_File(filepath, FILETYPE_VOC)
                        Addfile = False 'even if it succeeds, we only want to load 1 of this type of file into the cassiopei
                    Catch ex As Exception
                        MsgBox("Vocabulary file transfer error")
                    End Try

                Case ".WAV"
                    Debug.Print("User file (type WAVe) detected")
                    Try 'the selected userfile will be send to slave device
                        starttime = TimeOfDay.Ticks
                        clsUSB.Send_WAV_File(filepath)
                        Addfile = True
                    Catch ex As Exception
                        MsgBox("Wave file transfer error")
                    End Try

                    'Case ".DAT"
                Case Else
                    Debug.Print("User file (type DATa or unknown) detected")
                    Try 'the selected userfile will be send to slave device
                        starttime = TimeOfDay.Ticks
                        clsUSB.Send_DAT_File(filepath)
                        Addfile = True
                    Catch ex As Exception
                        MsgBox("Data file transfer error")
                    End Try

            End Select
        End If

        endtime = TimeOfDay.Ticks
        duration = endtime - starttime
        If (duration > 0) Then
            'note: calculation of transfer rate is not accurate at very small files, due to the low resolution of the tick counter
            transferrate = CInt(GetFilesizeSize(filepath) / (duration / (TimeSpan.TicksPerMillisecond * 1000)))
            Debug.Print("Transfer rate was " & transferrate & " bytes/sec")
        Else
            Debug.Print("Transfer rate could not be determined")
        End If

    End Function

    'This routine will extract a file from the CPIO's filesystem (for files of type .PRG or .DAT)
    'This routine expect that the "contextmenustrip" will protect against unsuported filetypes.
    'Therefore this routine will not need to check if the filetype is supported.
    Private Sub ExtractPrgFile()
        Dim filenamestring As String
        Dim firstaddress As UInteger
        Dim lastaddress As UInteger
        Dim nmbrofselectedfiles As Integer = 0
        Dim type As Integer

        type = Val(ListView.SelectedItems(0).SubItems(FileManagerColumn.type).Text)

        For Each i As ListViewItem In ListView.SelectedItems
            nmbrofselectedfiles = nmbrofselectedfiles + 1
            If nmbrofselectedfiles > 1 Then
                MessageBox.Show("Multiple file extraction is not supported, please select a single file")
                Exit Sub
            End If
        Next

        Buttons_Disable()

        filenamestring = ListView.SelectedItems(0).SubItems(FileManagerColumn.name).Text
        filenamestring = filenamestring.Trim                                            'remove padding spaces at the end of the filename
        filenamestring = filenamestring.ToLower                                         'change case to lowercase

        If (type = FILETYPE_DAT) Then
            firstaddress = 1
            lastaddress = Val(ListView.SelectedItems(0).SubItems(FileManagerColumn.realfilesize).Text)
            'determine if the DAT file is a D64 file using the filesize. This is: 174848 = 35 track (no errors), 175531 = 35 track (683 error bytes), 196608 = 40 track (no errors), 197376 = 40 track(768 error bytes)
            If ((lastaddress = 174848) Or (lastaddress = 175531) Or (lastaddress = 196608) Or (lastaddress = 197376)) Then
                If (Path.GetExtension(filenamestring) <> ".d64") Then filenamestring = filenamestring & ".d64"
                SaveFileDialog.Filter = "Disk image (*.D64)|*.D64|All files (*.*)|*.*"
            Else
                If (Path.GetExtension(filenamestring) <> ".dat") Then filenamestring = filenamestring & ".dat"
                SaveFileDialog.Filter = "Data file (*.DAT)|*.DAT|All files (*.*)|*.*"
            End If

            SaveFileDialog.ValidateNames = False
            SaveFileDialog.FileName = filenamestring    'parse the suggested filename to the dialog
            If (SaveFileDialog.ShowDialog = Windows.Forms.DialogResult.OK) Then
                Debug.Print("Extracting .D64 file from Cassiopei and saving to PC disk path: " & SaveFileDialog.FileName)
                clsUSB.Extract_file(Val(ListView.SelectedItems(0).SubItems(FileManagerColumn.index).Text), ((Val(ListView.SelectedItems(0).SubItems(FileManagerColumn.compmodel).Text) << 4) + Val(ListView.SelectedItems(0).SubItems(FileManagerColumn.type).Text)), SaveFileDialog.FileName, firstaddress, lastaddress)
            End If
        End If

        If (type = FILETYPE_PRG) Then
            firstaddress = Convert.ToInt32(ListView.SelectedItems(0).SubItems(FileManagerColumn.firstadr).Text.Replace("$", ""), 16)    'convert the string to a value (remove the $-sign), the string contains a value of base16 (hexadecimal)
            lastaddress = Convert.ToInt32(ListView.SelectedItems(0).SubItems(FileManagerColumn.lastadr).Text.Replace("$", ""), 16)      'convert the string to a value (remove the $-sign), the string contains a value of base16 (hexadecimal)
            If (Path.GetExtension(filenamestring) <> ".prg") Then filenamestring = filenamestring & ".prg"
            SaveFileDialog.Filter = "Programs and games (*.PRG)|*.PRG|All files (*.*)|*.*"
            SaveFileDialog.ValidateNames = False
            SaveFileDialog.FileName = filenamestring    'parse the suggested filename to the dialog
            If (SaveFileDialog.ShowDialog = Windows.Forms.DialogResult.OK) Then
                Debug.Print("Extracting .PRG file from Cassiopei and saving to PC disk path: " & SaveFileDialog.FileName)
                clsUSB.Extract_file(Val(ListView.SelectedItems(0).SubItems(FileManagerColumn.index).Text), ((Val(ListView.SelectedItems(0).SubItems(FileManagerColumn.compmodel).Text) << 4) + type), SaveFileDialog.FileName, firstaddress, lastaddress)
            End If
        End If

        Buttons_Enable()
    End Sub

    Private Sub btn_DeleteFile_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_DeleteFile.Click
        DeleteFile()
    End Sub

    'this procedure delete a file from flash
    'batch file deletion is not allowed, due to the fact that the Cassiopei uses not filenames but indexes, and indexes change if files dissapear!!!! So that does not work!!!
    Private Sub DeleteFile()
        Dim file As String = ""
        Dim type As Integer = FILETYPE_UNDEFINED
        Dim index_correction As Integer = 0

        If MessageBox.Show("Are you sure you want to delete the selected file(s)", "Delete file from flash chip", MessageBoxButtons.YesNo, MessageBoxIcon.Question) = DialogResult.Yes Then
            Buttons_Disable()
            'clsUSB.Delete_file(Val(ListView.SelectedItems(0).SubItems(FileManagerColumn.index).Text), Val(ListView.SelectedItems(0).SubItems(FileManagerColumn.type).Text))  'the fileindex and the type are stored in the .. column of the listview

            If (clsUSB.Display(DisplayX, DisplayY, "     Deleting file   ") = True) Then
                For Each i As ListViewItem In ListView.SelectedItems
                    If (type = Val(i.SubItems(FileManagerColumn.type).Text)) Then
                        index_correction = index_correction + 1 'there are allready ... files removed, so the index should be decreased by ... otherwise we delete the wrong file
                    Else
                        type = Val(i.SubItems(FileManagerColumn.type).Text)
                        index_correction = 0
                    End If
                    'the fileindex and the type are stored in the .. column of the listview
                    'the index as shown in the listview might require an adjustment because file earlier deleted in this session change the index of the following files
                    Try
                        Debug.Print("Attempting to delete file:" & i.SubItems(FileManagerColumn.name).Text)
                        clsUSB.Delete_file(Val(i.SubItems(FileManagerColumn.index).Text) - index_correction, ((Val(i.SubItems(FileManagerColumn.compmodel).Text) << 4) + Val(i.SubItems(FileManagerColumn.type).Text)))
                    Catch
                        MsgBox("Sorry, this version does not allow you to delete a range of files intended for different computermodels")
                        Exit For
                    End Try
                Next

                clsUSB.DisplayClearline(DisplayX, DisplayY)
                Buttons_Enable()
                btn_DeleteFile.Enabled = False
                Read_Flash_Directory()
            End If
            Buttons_Enable()    'enable buttons (if not already enabled)
        End If
    End Sub

    Private Sub ListView_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ListView.SelectedIndexChanged
        If ListView.SelectedIndices.Count <= 0 Then
            btn_DeleteFile.Enabled = False          'when nothing selected disabled buttons that require a selected file
            ContextMenuStrip1.Enabled = False
        Else
            btn_DeleteFile.Enabled = True               'a file is selected so the delete button can be used
            ContextMenuStrip1.Enabled = True

            'Check if there is (.PRG) in the listboxitem, if not the user may not extract this filetype
            'Debug.Print("selecteditem = " & ListView.SelectedItems(0).SubItems(col_name).Text) 'the filename is stored in the ... column

            Try
                If ((Val(ListView.SelectedItems(0).SubItems(FileManagerColumn.type).Text) = FILETYPE_PRG) Or
                    (Val(ListView.SelectedItems(0).SubItems(FileManagerColumn.type).Text) = FILETYPE_TAP)) Then 'filetype is stored in the .. column
                    ContextMenuStrip1.Items(0).Enabled = True
                Else
                    ContextMenuStrip1.Items(0).Enabled = False  '"use this file" function disabled when not a PRG or TAP file
                End If

                If ((Val(ListView.SelectedItems(0).SubItems(FileManagerColumn.type).Text) = FILETYPE_PRG) Or
                    (Val(ListView.SelectedItems(0).SubItems(FileManagerColumn.type).Text) = FILETYPE_DAT)) Then 'filetype is stored in the .. column
                    ContextMenuStrip1.Items(1).Enabled = True
                Else
                    ContextMenuStrip1.Items(1).Enabled = False  'extract function disabled when not a PRG file
                End If

                If (Val(ListView.SelectedItems(0).SubItems(FileManagerColumn.type).Text) = FILETYPE_EEP) Then 'filetype is stored in the .. column
                    btn_DeleteFile.Enabled = False
                    ContextMenuStrip1.Items(3).Enabled = False  'settings file may not be deleted, so the button needs to be disabled when such a file is selected
                Else
                    btn_DeleteFile.Enabled = True
                    ContextMenuStrip1.Items(3).Enabled = True
                End If

            Catch
                btn_DeleteFile.Enabled = False          'disable functionality
                ContextMenuStrip1.Enabled = False
            End Try
        End If
    End Sub

    Private Sub UseThisFilesetModeAndIndexToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles UseThisFileToolStripMenuItem.Click
        Buttons_Disable()

        If (Val(ListView.SelectedItems(0).SubItems(FileManagerColumn.compmodel).Text) = cmb_SettingComputerModel.SelectedIndex) Then
            Select Case (Val(ListView.SelectedItems(0).SubItems(FileManagerColumn.type).Text))
                Case FILETYPE_PRG

                    If MessageBox.Show("Do you want to load this file using the fastloader?" & vbCrLf & "Yes = Fast loader" & vbCrLf & "No = Slow kernal loader", "Select loading method", MessageBoxButtons.YesNo, MessageBoxIcon.Question) = DialogResult.Yes Then
                        cmb_SettingFileMode.SelectedIndex = 1 '.PRG - Fast loader (high speed), Flash
                    Else
                        cmb_SettingFileMode.SelectedIndex = 0 '.PRG - Kernal loader (slow speed), Flash
                    End If


                Case FILETYPE_TAP
                    cmb_SettingFileMode.SelectedIndex = 3 '.TAP - Standard loader(slow speed), Flash
                    trk_TAPfile.Value = 0
                    txt_TAP_status.Text = "counter set to 0"

            End Select

            cmb_SettingFileIndex.SelectedIndex = Val(ListView.SelectedItems(0).SubItems(FileManagerColumn.index).Text)
            WriteSettingsToEEPROM()
        Else
            MessageBox.Show("The file you have selected cannot be used by the Cassiopei because it was intended for a different computermodel. " &
                            "The Cassiopei is currently configured to be used in combination with a " & cmb_SettingComputerModel.SelectedItem & "." & vbCrLf &
                            "Please select a different file or change the computermodel settings of the Cassiopei, which can be found in the settings tab.",
                            "Request denied", MessageBoxButtons.OK, MessageBoxIcon.Information)
        End If

        Buttons_Enable()
    End Sub

    Private Sub ExtractFileToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExtractFileToolStripMenuItem.Click
        ExtractPrgFile()
    End Sub

    Private Sub DeleteFileToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles DeleteFileToolStripMenuItem.Click
        DeleteFile()
    End Sub

    '****************************************************************************************************************************************************
    'Flash viewer related functions *********************************************************************************************************************
    '****************************************************************************************************************************************************

    'this routine will read the contents of the flash memory of the CPIO device and shows it in hexadecimal and ASCII format
    Private Sub btn_ReadFlash_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_ReadFlash.Click
        Dim address As ULong
        Dim adr2 As Byte = 0
        Dim adr1 As Byte = 0
        Dim adr0 As Byte = 0
        Dim lp As Integer
        Dim lpmax As Integer
        Dim HEX_result As String
        Dim ASCII_result As String
        Dim tmpstr As String
        Dim i As Integer
        Dim value() As Byte

        Buttons_Disable()

        If (clsUSB.Display(DisplayX, DisplayY, "Reading flash memory ") = True) Then
            i = nud_FlashAddress.Value
            value = BitConverter.GetBytes(i)
            adr2 = value(2) 'MSB
            adr1 = value(1) '.SB
            adr0 = value(0) 'LSB

            Debug.Print("Flash_Monitor address is:" & nud_FlashAddress.Value & "=" & adr2 & "," & adr1 & "," & adr0)

            lpmax = Val(cmb_numberofbytes.SelectedItem) / 32  'divide by 32 because the data is send in packages of 32 bytes

            Dim pgrBar As New frm_ProgressBar
            pgrBar.Init("Reading data from Cassiopei's Flash memory", 0, lpmax)
            pgrBar.Show()

            tmpstr = ""             'we use a tmp string, simply because it is faster then updating the textbox lost and lost of times
            For lp2 = 1 To lpmax

                If (clsUSB.Read_32Bytes_From_Flash(adr2, adr1, adr0) = True) Then
                    address = (adr2 * 256 * 256) + (adr1 * 256) + adr0
                    HEX_result = address.ToString("X6") & ": "
                    ASCII_result = "" 'clear string
                    For lp = 0 To 15 'this loops runs 16 times
                        HEX_result = HEX_result & clsUSB.DataFromDevice(lp + 2).ToString("X2") & " "
                        ASCII_result = ASCII_result & ASCII_table(clsUSB.DataFromDevice(lp + 2))
                    Next lp
                    tmpstr = tmpstr & HEX_result & "  " & ASCII_result & vbCrLf
                    address = address + 16

                    HEX_result = address.ToString("X6") & ": "
                    ASCII_result = "" 'clear string
                    For lp = 16 To 31 'this loops runs 16 times
                        HEX_result = HEX_result & clsUSB.DataFromDevice(lp + 2).ToString("X2") & " "
                        ASCII_result = ASCII_result & ASCII_table(clsUSB.DataFromDevice(lp + 2))
                    Next lp
                    tmpstr = tmpstr & HEX_result & "  " & ASCII_result & vbCrLf
                Else
                    tmpstr = tmpstr & address.ToString("X6") & ": --  error reading data --" & vbCrLf
                    Exit For
                End If

                If adr0 < (256 - 32) Then
                    adr0 = adr0 + 32
                Else
                    adr0 = 0
                    If adr1 < 255 Then
                        adr1 = adr1 + 1
                    Else
                        adr1 = 0
                        adr2 = adr2 + 1
                    End If
                End If

                pgrBar.Value(lp2)
                Application.DoEvents()      'update the GUI!!!
            Next lp2
            pgrBar.Dispose()

            txt_Flash.Text = tmpstr
            txt_Flash.Refresh()
            clsUSB.DisplayClearline(DisplayX, DisplayY)
        End If

        Buttons_Enable()
    End Sub

    Private Sub btn_BackupFlashFilesystem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_BackupFlashFilesystem.Click
        Dim address As Long = 0 'this value may not exceed "FSbackupsize" as defined in the constants area
        Dim value() As Byte
        Dim lp As Integer
        Dim wFile As System.IO.FileStream

        Buttons_Disable()
        If MessageBox.Show("Are you sure you want to backup the entire flash chip to a file?" & vbCrLf &
                           "This operation will take approx. 10 minutes to complete", "Create backup file of the flash filesystem", MessageBoxButtons.YesNo, MessageBoxIcon.Question) = DialogResult.Yes Then

            SaveFileDialog.ValidateNames = False
            SaveFileDialog.FileName = "Cassiopei_FS.bak"    'parse the suggested filename to the dialog
            SaveFileDialog.Filter = "Backup files (*.BAK)|*.BAK|All files (*.*)|*.*"
            If (SaveFileDialog.ShowDialog = Windows.Forms.DialogResult.OK) Then
                wFile = New FileStream(SaveFileDialog.FileName, FileMode.Create)            'open the file to which we want to write

                'send a message to the display, if this does not respond, then we shoudl not attempt to read the dir, because that most likely will also fail
                If (clsUSB.Display(DisplayX, DisplayY, " Reading filesystem  ") = True) Then
                    Dim pgrBar As New frm_ProgressBar
                    pgrBar.Init("Reading data from Cassiopei's Flash memory", 0, FilesystemSize)
                    pgrBar.Show()

                    For address = 0 To FilesystemSize Step PACKET_PAYLOADSIZE_DATAFILE      'step=32 because we are reading blocks of 32 bytes
                        value = BitConverter.GetBytes(address)
                        clsUSB.Read_Bytes_From_Flash(value(2), value(1), value(0))

                        For lp = 0 To (PACKET_PAYLOADSIZE_DATAFILE - 1)
                            If (wFile.Length < FilesystemSize) Then               'because FSbackupsize is not a multiple of the PACKET_PAYLOADSIZE_DATAFILE, we must prevent
                                wFile.WriteByte(clsUSB.DataFromDevice(2 + lp))  'writing more data to the destination file then required, so when we've reached our goal we stop writing
                            End If
                        Next lp

                        'Debug.Print("address=" & address)
                        If (address Mod (PACKET_PAYLOADSIZE_DATAFILE * 100) = 0) Then  'update only on every 4 KByte (if we do it on every byte, then it would slow down this for-next loop significantly)
                            pgrBar.Value(address)       'update progressbar
                            Application.DoEvents()      'update the GUI!!!
                        End If
                    Next address
                    clsUSB.DisplayClearline(DisplayX, DisplayY)
                    wFile.Close()       'close the file
                    pgrBar.Dispose()
                End If
            End If
        End If
        Buttons_Enable()
    End Sub

    Private Sub btn_RestoreFlashFilesystem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_RestoreFlashFilesystem.Click
        Dim address As Long = 0 'this value may not exceed "FSbackupsize" as defined in the constants area

        Buttons_Disable()
        If MessageBox.Show("Attention: this operation will overwrite the contents of the flash filesystem! " &
                           "Are you sure you want to overwrite the flash filesystem with the contents of a backup file?" & vbCrLf & vbCrLf &
                           "This operation will take approx. 10 minutes to complete.", "Restore flash filesystem from backup file", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question) = DialogResult.Yes Then

            OpenFileDialog.ValidateNames = False
            OpenFileDialog.FileName = "Cassiopei_FS.bak"
            OpenFileDialog.Filter = "Backup files (*.BAK)|*.BAK|All files (*.*)|*.*"
            OpenFileDialog.Multiselect = False 'do not allow user to select more then one file
            If (OpenFileDialog.ShowDialog = Windows.Forms.DialogResult.OK) Then
                If MessageBox.Show("Are you really sure you want to overwrite the flash filesystem with the" & vbCrLf &
                                   "contents of the file: " & System.IO.Path.GetFileName(OpenFileDialog.FileName), "Restore flash filesystem from backup file", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question) = DialogResult.Yes Then

                    If (clsUSB.Display(DisplayX, DisplayY, "Erasing flash memory ") = True) Then
                        clsUSB.EraseAllFlash()    'ok, you asked for it, flash chip will be erased, this way we can write back the data to flash without difficulty
                        clsUSB.Display(DisplayX, DisplayY, " Writing filesystem  ")
                        clsUSB.Send_data_File(OpenFileDialog.FileName, 0, 0, 0)
                        clsUSB.DisplayClearline(DisplayX, DisplayY)
                        Read_Flash_Directory()
                    End If
                End If
            End If
        End If
        Buttons_Enable()
    End Sub

    'this procedure erases the flash chip, ask the user if he/she knows what he/she is about to do (better save then sorry...)
    Private Sub btn_EraseAllFlash_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_EraseAllFlash.Click
        Buttons_Disable()
        If MessageBox.Show("Are you sure you want to erase the entire flash chip of the Cassiopei?", "Erase flash chip", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question) = DialogResult.Yes Then
            If MessageBox.Show("Are you really sure?" & vbCrLf & "This action will delete all your files!", "Erase flash chip", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question) = DialogResult.Yes Then
                If (clsUSB.Display(DisplayX, DisplayY, "Erasing flash memory ") = True) Then
                    clsUSB.EraseAllFlash()    'ok, yo asked for it, flash chip will be erased...
                    clsUSB.DisplayClearline(DisplayX, DisplayY)
                End If
            End If
        End If
        Buttons_Enable()
        Read_Flash_Directory()
    End Sub

    '****************************************************************************************************************************************************
    'EEPROM (settings in cassiopei) related functions ***************************************************************************************************
    '****************************************************************************************************************************************************

    Private Sub ReadEEPROMContents()
        Dim line As Integer
        Dim lp As Integer
        Dim HEX_result As String
        Dim ASCII_result As String
        Dim data As Byte
        Dim address As Integer

        address = 0
        For lp = 0 To 0 'we only need to execute this loop 1 time, because we have only 16 available positions to read
            HEX_result = address.ToString("X6") & ": "
            ASCII_result = ""
            For line = 0 To 14 'read to 14 and not 15 as we have only 15 registers te read and we start with 0
                data = clsUSB.Read_Byte_From_EEPROM(CByte(address))
                'Debug.Print("address:" & address & " data:" & data & "      lp=" & lp & "  line=" & line)
                address = address + 1
                HEX_result = HEX_result & data.ToString("X2") & " "
                ASCII_result = ASCII_result & ASCII_table(data)
            Next
        Next

        Try
            ReadSettingsFromEEPROM()
        Catch
            If MessageBox.Show("An error occurred during reading of EEPROM values." & vbCrLf & "Restore settings to default?", "Restore settings?", MessageBoxButtons.YesNo, MessageBoxIcon.Question) = DialogResult.Yes Then
                Try
                    clsUSB.Write_Byte_To_EEPROM(0, 0) 'standard speed (.PRG)
                    clsUSB.Write_Byte_To_EEPROM(1, 0) 'currently selected file is the first file found
                    clsUSB.Write_Byte_To_EEPROM(2, 2) 'C64 (PAL) is the computer to be used with the Cassiopei
                    clsUSB.Write_Byte_To_EEPROM(3, 0) 'feedback volume OFF
                    clsUSB.Write_Byte_To_EEPROM(4, 4) 'C128 mode of operation (4=C128 mode)
                    ReadSettingsFromEEPROM()

                Catch ex As Exception
                    MsgBox("An error occurred during restoration of EEPROM values." & vbCrLf & "Please check your setup")
                    Exit Sub 'stop on first error
                End Try
            End If
        End Try
    End Sub

    Private Sub ReadSettingsFromEEPROM()
        Dim data As Byte

        cmb_SettingFileMode.SelectedIndex = clsUSB.Read_Byte_From_EEPROM(0)

        cmb_SettingFileIndex.SelectedIndex = clsUSB.Read_Byte_From_EEPROM(1)

        data = clsUSB.Read_Byte_From_EEPROM(2)
        cmb_SettingComputerModel.SelectedIndex = data >> 1   'only use bit 7...1
        cmb_SettingComputerModel_PalNtsc.SelectedIndex = data And 1 'only use bit 0

        cmb_SettingFeedbackVolume.SelectedIndex = clsUSB.Read_Byte_From_EEPROM(3)
        txt_C128_mode_of_operation.Text = clsUSB.Read_Byte_From_EEPROM(4).ToString
    End Sub

    Private Sub btn_WriteSettingsToEEPROM_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_WriteSettingsToEEPROM.Click
        WriteSettingsToEEPROM()
    End Sub

    Private Sub WriteSettingsToEEPROM()
        Buttons_Disable()

        If (clsUSB.Display(DisplayX, DisplayY, "   Writing settings  ") = True) Then
            clsUSB.Write_Byte_To_EEPROM(0, cmb_SettingFileMode.SelectedIndex)
            clsUSB.Write_Byte_To_EEPROM(1, cmb_SettingFileIndex.SelectedIndex)
            clsUSB.Write_Byte_To_EEPROM(2, ((cmb_SettingComputerModel.SelectedIndex << 1) + cmb_SettingComputerModel_PalNtsc.SelectedIndex))
            clsUSB.Write_Byte_To_EEPROM(3, cmb_SettingFeedbackVolume.SelectedIndex)
            'clsUSB.Write_Byte_To_EEPROM(4, Val(txt_C128_mode_of_operation.Text))

            'clsUSB.DisplayClearline(DisplayX, DisplayY) 'this command is not usefull because it will be overwrtitten immediately by the Read_Flash_Directoy routine that also want to write to the same display location

            Read_Flash_Directory()  'reading the directory again as the index might have been changed and if so then the screen requires to be updated
        End If

        Buttons_Enable()
    End Sub




    '****************************************************************************************************************************************************
    'Virtual file related functions *********************************************************************************************************************
    '****************************************************************************************************************************************************

    'this routine will force a file to be send to the CPIO device
    'the proper procedure would be to start loading a file from the C64, then it will wait until the user confirms this load by pressing the 'force' button
    Private Sub btn_SendVirtual_PRG_File_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_SendVirtual_PRG_File.Click
        If (txt_VirtualPrgFile.Text = "") Then
            MessageBox.Show("Please select a .PRG file to be transferred.", "No file selected", MessageBoxButtons.OK)
        Else
            Buttons_Disable()
            Dim pgrBar As New frm_ProgressBar           'when the Simulate_button_Play command is given, the cassiopei will not respond for a few seconds
            pgrBar.Init("Preparing transfer", 0, 2)     'to indicate action, a dummy progressbar is shown with the text "preparing transfer"
            pgrBar.Value(1)
            pgrBar.Show()
            Application.DoEvents()          'update the GUI!!!
            clsUSB.Simulate_Button_Play()   'simulate a play-button press on the Cassiopei
            pgrBar.Dispose()                'the dummy progressbar is no longer needed

            clsUSB.Send_Virtual_PRG_File(txt_VirtualPrgFile.Text)
        End If
        Buttons_Enable()
    End Sub

    'select the file that is being "served" for "virtual file" transfer (that's when the CPIO device directly loads the file into the C64. The file is not stored on flash!)
    'this mode is perfect for development (the situation where a file changes constantly and it is not usefull to be saved to flash)
    Private Sub btn_SelectVirtual_PRG_File_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_SelectVirtual_PRG_File.Click
        OpenFileDialog.ValidateNames = False
        OpenFileDialog.FileName = ""
        OpenFileDialog.Filter = "Programs and games (*.PRG)|*.PRG"

        If (OpenFileDialog.ShowDialog = Windows.Forms.DialogResult.OK) Then
            txt_VirtualPrgFile.Text = OpenFileDialog.FileName
            My.Settings.str_UsedVirtualPrgFile = OpenFileDialog.FileName
            My.Settings.Save()
        End If
    End Sub

    'using a timer the virtual TAP packages are send.
    'we do this using a timer because this gives the possibillity of checking thu buttons using normal button event routines
    'therefore no endless loops (of event checking routines inside the virtual TAP file routine) are required
    Private Sub btn_SelectVirtual_TAP_File_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_SelectVirtual_TAP_File.Click
        OpenFileDialog.ValidateNames = False
        OpenFileDialog.FileName = ""
        OpenFileDialog.Filter = "TAPe emulation (*.TAP)|*.TAP"

        If (OpenFileDialog.ShowDialog = Windows.Forms.DialogResult.OK) Then
            txt_VirtualTapFile.Text = OpenFileDialog.FileName
            My.Settings.str_UsedVirtualTapFile = OpenFileDialog.FileName
            My.Settings.Save()
        End If
    End Sub

    Private Sub btn_SendVirtual_TAP_File_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_SendVirtual_TAP_File.Click
        If (txt_VirtualTapFile.Text = "") Then
            MessageBox.Show("Please select a .TAP file to be transferred.", "No file selected", MessageBoxButtons.OK)
        Else
            'check if file is usable
            Buttons_Disable()
            If (clsTAP.Init_TAP_file(txt_VirtualTapFile.Text, False) = True) Then   'virtual files do not use compression
                clsUSB.Simulate_Button_Play()               'simulate a play-button press on the Cassiopei (so the user doesn't have to press the button)
                VirtualTapCounter = 0                       'at the beginning of a file, the counter is allways at 0
                TabControl.SelectTab(2)                     'show the tab that holds the tape animation
                PlayTAPfile()                               'this routine will show the tape animation and set the correct timer flags
            Else
                Buttons_Enable()                            'oops, file could not be used, enable buttons again
            End If
        End If
    End Sub

    '****************************************************************************************************************************************************
    'Tape related functions *****************************************************************************************************************************
    '****************************************************************************************************************************************************

    Private Sub UpdateCounterAndPositionIndicator(ByVal pos As Long)
        Select Case (cmb_SettingFileMode.SelectedIndex)
            Case OPERATINGMODE_TAP_FLASH, OPERATINGMODE_TAP_USB
                If (pos < 0) Then                              'no valid info available
                    txt_TAP_status.Text = "- - - - -"          'fill the version textbox           
                    txt_Counter.Text = "- - -"
                    trk_TAPfile.Value = 0
                    StopAllTapeActivity()
                Else
                    If (pos > trk_TAPfile.Maximum) Then
                        pos = trk_TAPfile.Maximum
                        StopAllTapeActivity()                  'we are reading outside the file, this is not good, stop playback, forward or status requests
                        MsgBox("End of tape detected, all actions are stopped." & vbCrLf & "Rewind the tape in order to continue.")
                    End If

                    trk_TAPfile.Value = pos
                    txt_TAP_status.Text = pos.ToString("D8")
                    txt_Counter.Text = pos.ToString("D8")
                End If
        End Select
    End Sub

    Private Sub trk_TAPfile_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles trk_TAPfile.Scroll
        Select Case (cmb_SettingFileMode.SelectedIndex)
            Case OPERATINGMODE_TAP_FLASH
                clsUSB.TAPposition(trk_TAPfile.Value)                       'send command with the new file position to the Cassiopei

            Case OPERATINGMODE_TAP_USB
                VirtualTapCounter = trk_TAPfile.Value                       'update the file pointer of the TAP file on the PC
        End Select
        UpdateCounterAndPositionIndicator(trk_TAPfile.Value)                'update the counters and position indicator
    End Sub

    Private Sub StopAllTapeActivity()
        Select Case (cmb_SettingFileMode.SelectedIndex)
            Case OPERATINGMODE_TAP_FLASH
                clsUSB.TAPstop()     'send command to cassiopei
                FlashTapMode = FlashTapModes.idle

            Case OPERATINGMODE_TAP_USB
                VirtualTapMode = VirtualTapModes.idle               'the virtual TAP file mode

        End Select

        Timer_TAP.Enabled = False
        Timer_TAPanim.Enabled = False
        My.Computer.Audio.Stop()    'stop looping sounds
        My.Computer.Audio.Play(My.Resources.C2N_ButtonRelease, AudioPlayMode.WaitToComplete)
        Buttons_Enable()
    End Sub

    Private Sub btn_TAPStop_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_TAPStop.Click, btn_TAPStop_2.Click
        StopAllTapeActivity()
    End Sub

    Private Sub btn_Status_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_TAPStatus.Click
        Buttons_Disable()
        FlashTapMode = FlashTapModes.status
        Timer_TAP.Enabled = True
    End Sub

    Private Sub btn_TAPPlay_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_TAPPlay.Click, btn_TAPPlay_2.Click
        PlayTAPfile()
        txt_TAP_status.Text = "searching tape position"
    End Sub

    Private Sub PlayTAPfile()
        Select Case (cmb_SettingFileMode.SelectedIndex)
            Case OPERATINGMODE_TAP_FLASH
                clsUSB.TAPplay()                                    'send command to cassiopei               
                FlashTapMode = FlashTapModes.play

            Case OPERATINGMODE_TAP_USB
                txt_TAPfilename.Text = txt_VirtualTapFile.Text      'show the name of the used virtual TAP file
                trk_TAPfile.Maximum = clsTAP.Datasize               'set max size of trackbar
                VirtualTapMode = VirtualTapModes.play               'the virtual TAP file mode

        End Select

        Buttons_Disable()
        Timer_TAP.Enabled = True
        My.Computer.Audio.Play(My.Resources.C2N_ButtonPress, AudioPlayMode.WaitToComplete)
        'My.Computer.Audio.Play(My.Resources.C2N_Play, AudioPlayMode.BackgroundLoop)
    End Sub

    Private Sub btn_TAPRewind_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_TAPRewind.Click, btn_TAPRewind_2.Click
        Select Case (cmb_SettingFileMode.SelectedIndex)
            Case OPERATINGMODE_TAP_FLASH
                FlashTapMode = FlashTapModes.rewind

            Case OPERATINGMODE_TAP_USB
                VirtualTapMode = VirtualTapModes.rewind             'the virtual TAP file mode
        End Select

        Buttons_Disable()
        Timer_TAP.Enabled = True
        My.Computer.Audio.Play(My.Resources.C2N_ButtonPress, AudioPlayMode.WaitToComplete)
        My.Computer.Audio.Play(My.Resources.C2N_RWD, AudioPlayMode.BackgroundLoop)
    End Sub

    Private Sub btn_TAPForward_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_TAPForward.Click, btn_TAPForward_2.Click
        Select Case (cmb_SettingFileMode.SelectedIndex)
            Case OPERATINGMODE_TAP_FLASH
                FlashTapMode = FlashTapModes.forward

            Case OPERATINGMODE_TAP_USB
                VirtualTapMode = VirtualTapModes.forward            'the virtual TAP file mode
        End Select

        Buttons_Disable()
        Timer_TAP.Enabled = True
        My.Computer.Audio.Play(My.Resources.C2N_ButtonPress, AudioPlayMode.WaitToComplete)
        My.Computer.Audio.Play(My.Resources.C2N_FFWD, AudioPlayMode.BackgroundLoop)
    End Sub

    Private Sub btn_TAPRecord_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_TAPRecord.Click
        MsgBox("Sorry, the record button has no function")
    End Sub

    Private Sub btn_TAPEject_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_TAPEject.Click
        MsgBox("Sorry, the eject button has no function" & vbCrLf & "select a different file using the 'menu' button on the Cassiopei or" & vbCrLf & "by changing the index setting in the settings tab.")
    End Sub

    Private Sub Timer_TAP_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer_TAP.Tick
        Dim pos As Long
        Static prev_pos As Long = 0

        Select Case (cmb_SettingFileMode.SelectedIndex)
            Case OPERATINGMODE_TAP_FLASH    '####################################################################################################################
                Timer_TAP.Interval = 333                                        'use a nice value, not to slow and not to fast
                Select Case (FlashTapMode)
                    Case FlashTapModes.forward
                        pos = Val(txt_TAP_status.Text)
                        pos = pos + FFWD_RWD_SPEED                              'forward the TAP position ... bytes
                        clsUSB.TAPposition(pos)                                 'send command to cassiopei
                        Timer_TAPanim.Enabled = True
                        UpdateCounterAndPositionIndicator(pos)                  'update the counters and position indicator

                    Case FlashTapModes.rewind
                        pos = Val(txt_TAP_status.Text)
                        If (pos > FFWD_RWD_SPEED) Then                          'we must make sure that the value stays positive !!!
                            pos = pos - FFWD_RWD_SPEED                          'rewind the TAP position ... bytes
                        Else
                            pos = 0
                            StopAllTapeActivity()                               'start of tape reached, stop rewinding!
                        End If
                        clsUSB.TAPposition(pos)                                 'send command to cassiopei
                        Timer_TAPanim.Enabled = True
                        UpdateCounterAndPositionIndicator(pos)                  'update the counters and position indicator

                    Case FlashTapModes.play, FlashTapModes.status               'during play or status we must retrieve the statuis of the cassiopei
                        pos = clsUSB.TAPstatus()                                'get value
                        If (pos = prev_pos) Then                                'control the animation, when there is no tape movement, stop the animation and vice versa
                            Timer_TAPanim.Enabled = False
                        Else
                            Timer_TAPanim.Enabled = True
                        End If
                        prev_pos = pos
                        UpdateCounterAndPositionIndicator(pos)                  'update the counter and position indicator (and stop all if something is not OK), when the Cassiopei does not respond (because it is disconnected) the calling routine replies with -1
                End Select



            Case OPERATINGMODE_TAP_USB    '####################################################################################################################
                Select Case VirtualTapMode
                    Case VirtualTapModes.play

                        'Dim ts As TimeSpan = stopWatch.Elapsed
                        'Dim elapsedTime As String
                        'stopWatch.Stop()
                        'elapsedTime = String.Format("{0:000}", ts.Milliseconds)
                        'Debug.Print(elapsedTime)
                        'stopWatch.Restart()


                        Timer_TAP.Interval = 1                                                  'use the fastest possible timing
                        Timer_TAP.Enabled = False                                               'disable the timer to prevent the timer from going off while we are still processing the previous timer event
                        Timer_TAPanim.Enabled = True                                            'start animation timer
                        VirtualTapCounter = clsUSB.Send_Virtual_TAP_Packet(VirtualTapCounter)   'when this routine was succesfull the timer will be enabled again
                        If (VirtualTapCounter > 0) Then
                            Timer_TAP.Enabled = True
                        End If

                        If (clsUSB.buf_Underflow > 255) Then
                            StopAllTapeActivity()                                               'start of tape reached, stop rewinding!
                            MessageBox.Show("Virtual TAP transfer failed, buffer underrun" & vbCrLf &
                                            "Make sure the Cassiopei is not connected to a USB HUB when using Windows XP (see manual)" & vbCrLf &
                                            "If not then perhaps another process/application on your PC is requesting too much CPU time" & vbCrLf &
                                            "Close all other applications to save timing resources and reset the CBM computer," & vbCrLf &
                                            "also reset the Cassiopei in order to try again.",
                                            "Virtual TAP file buffer underrun", MessageBoxButtons.OK)
                        Else
                            UpdateCounterAndPositionIndicator(VirtualTapCounter)                'update tape counter value
                        End If



                    Case VirtualTapModes.forward
                        Timer_TAP.Interval = 333                                                'changing TAP-file position must not happen too fast, 3 times per second gives a nice "movement" of the tapecounter
                        Timer_TAPanim.Enabled = True
                        If (VirtualTapCounter < (clsTAP.Datasize - FFWD_RWD_SPEED)) Then
                            VirtualTapCounter = VirtualTapCounter + FFWD_RWD_SPEED
                        Else
                            VirtualTapCounter = clsTAP.Datasize
                            StopAllTapeActivity()                                               'end of TAP-file reached, stop rewinding!
                            Timer_TAP.Enabled = False                                           'nothing more to do, stop the timer
                        End If
                        UpdateCounterAndPositionIndicator(VirtualTapCounter)                    'update tape counter value

                    Case VirtualTapModes.rewind
                        Timer_TAP.Interval = 333                                                'changing TAP-file position must not happen too fast, 3 times per second gives a nice "movement" of the tapecounter
                        Timer_TAPanim.Enabled = True
                        If (VirtualTapCounter > FFWD_RWD_SPEED) Then
                            VirtualTapCounter = VirtualTapCounter - FFWD_RWD_SPEED
                        Else
                            VirtualTapCounter = 0
                            StopAllTapeActivity()                                               'start of tape reached, stop rewinding!
                            Timer_TAP.Enabled = False                                           'nothing more to do, stop the timer
                        End If
                        UpdateCounterAndPositionIndicator(VirtualTapCounter)                    'update tape counter value

                    Case Else
                        Timer_TAP.Interval = 1                                                  'set to fastest, so the next time we get here a quickly as possible
                        Timer_TAP.Enabled = False                                               'undefined action, so do nothing and stop
                        Timer_TAPanim.Enabled = False
                        UpdateCounterAndPositionIndicator(VirtualTapCounter)                    'update tape counter value
                End Select
        End Select
    End Sub

    Private Sub Timer_Animation_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer_TAPanim.Tick
        Static frame As Integer = 0

        Select Case (frame)
            Case 0
                pbx_TapeAnimation.Image = My.Resources.Tape000
            Case 1
                pbx_TapeAnimation.Image = My.Resources.Tape001
            Case 2
                pbx_TapeAnimation.Image = My.Resources.Tape002
            Case 3
                pbx_TapeAnimation.Image = My.Resources.Tape003
            Case 4
                pbx_TapeAnimation.Image = My.Resources.Tape004
            Case 5
                pbx_TapeAnimation.Image = My.Resources.Tape005
            Case 6
                pbx_TapeAnimation.Image = My.Resources.Tape006
            Case 7
                pbx_TapeAnimation.Image = My.Resources.Tape007
        End Select

        If ((FlashTapMode = FlashTapModes.status) Or (FlashTapMode = FlashTapModes.play) Or (VirtualTapMode = VirtualTapModes.play)) Then
            Timer_TAPanim.Interval = CassetteAnimSpeed_play       'set animation speed to simulate playback
            frame = frame + 1                                       'increment frame counter (play animation in normal direction)
            If (frame > (CassetteAnimSize - 1)) Then                '-1 because our first frame is labelled as 0 and not as 1
                frame = 0
            End If
        End If

        If ((FlashTapMode = FlashTapModes.forward) Or (VirtualTapMode = VirtualTapModes.forward)) Then
            Timer_TAPanim.Interval = CassetteAnimSpeed_wind       'set animation speed to simulate winding
            frame = frame + 1                                       'increment frame counter (play animation in normal direction)
            If (frame > (CassetteAnimSize - 1)) Then                '-1 because our first frame is labelled as 0 and not as 1
                frame = 0
            End If
        End If

        If ((FlashTapMode = FlashTapModes.rewind) Or (VirtualTapMode = VirtualTapModes.rewind)) Then
            Timer_TAPanim.Interval = CassetteAnimSpeed_wind       'set animation speed to simulate winding
            If (frame > 0) Then
                frame = frame - 1                                   'increment frame counter (play animation in reverse direction)
            Else
                frame = CassetteAnimSize - 1                        '-1 because our first frame is labelled as 0 and not as 1
            End If
        End If

    End Sub

    '*************************************************************************************************************************************
    '*************************************************************************************************************************************
    '*************************************************************************************************************************************

    ''this routine will read a disc from a real drive and convert it into a D64 file
    'Private Sub btn_CreateD64_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_CreateD64.Click
    '    Buttons_Disable()

    '    SaveFileDialog.ValidateNames = False
    '    SaveFileDialog.FileName = "Disc"    'parse the suggested filename to the dialog
    '    SaveFileDialog.Filter = "Disc image (*.D64)|*.D64|All files (*.*)|*.*"
    '    If (SaveFileDialog.ShowDialog = Windows.Forms.DialogResult.OK) Then
    '        Debug.Print("Request data from Cassiopei")

    '        Debug.Print("Waiting for Cassiopei to send the file data")

    '        Debug.Print("Receiving data from Cassiopei")
    '        clsUSB.TransferDiscImage(SaveFileDialog.FileName)
    '        Debug.Print("Finished")
    '    End If
    '    Buttons_Enable()

    'End Sub


    'Private Sub btn_CreateDisc_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_CreateDisc.Click
    '    'Try 'the selected systemfile will be send to slave device
    '    '    Debug.Print("start transfer of system file")
    '    '    starttime = TimeOfDay.Ticks
    '    '    clsUSB.Send_data_File(filepath, 0, 0, 0) 'this is filetype &H2, but there is no need to send this parameter as it is allready in the file
    '    '    Debug.Print("transfer of system file finished")
    '    '    Addfile = False 'even if it succeeds, we only want to load 1 of this type of file into the cassiopei
    '    'Catch ex As Exception
    '    '    MsgBox("System file transfer error")
    '    'End Try
    'End Sub

End Class
