﻿Imports System.IO
Imports HIDLibrary
Imports System.Threading
Imports System.Diagnostics 'used for stopwatch class

Public Class cls_USB_Cassiopei
    Private HidDeviceList As HIDLibrary.HidDevice()
    Public WithEvents HIDDUT As HIDLibrary.HidDevice
    Private USIB_IO_error As Boolean = False

    Public DataToDevice(65) As Byte        'the outputdata buffer is set to the max packet size for a HID device
    Public DataFromDevice(65) As Byte      'the outputdata buffer is set to the max packet size for a HID device

    '-----------------------------------------------------------

    Public FileInfo_BlockSize As UInteger
    Public FileInfo_Name As String
    Public FileInfo_AdrFirst As String
    Public FileInfo_AdrLast As String
    Public FileInfo_Type As String
    Public FileInfo_CompModel As Byte
    Public FileInfo_Date As String
    Public FileInfo_Time As String
    Public FileInfo_FirstBlock As String
    Public FileInfo_RealSize As String

    Public buf_Underflow As UInteger

    '-----------------------------------------------------------

    'This routine will try to open the specified USB device.
    Public Function Initialize() As Boolean
        Initialize = True

        Try
            HidDeviceList = HidDevices.Enumerate(VID, PID) ' Enumerate the device(s) with the Vendor Id and Product Id (CreateFile)
            If HidDeviceList.Length > 0 Then
                HIDDUT = HidDeviceList(0) 'use the first device
                If Not HIDDUT.IsOpen Then
                    HIDDUT.Open()
                    'Debug.Print("USB routines activated, device connected")
                End If
            Else
                USIB_IO_error = True
                Initialize = False
            End If

        Catch ex As Exception
            DisplayException("USB-IO", ex)
            USIB_IO_error = True
            Initialize = True
            'Throw
        End Try
    End Function

    'This routine sends the data to the USB device
    Public Function SendDataToDevice() As Boolean
        If USIB_IO_error = True Then
            SendDataToDevice = False
            Exit Function
        End If

        Try
            If HIDDUT.IsOpen Then
                HIDDUT.Write(DataToDevice)
                SendDataToDevice = True
            Else
                SendDataToDevice = False
            End If

        Catch ex As Exception
            DisplayException("USB-IO", ex)
            SendDataToDevice = False
            'Throw
        End Try
    End Function


    'This routine gets data from the USB device
    Public Function GetDataFromDevice() As Boolean
        Dim HIDDUTData As HidDeviceData
        Dim lp As Integer

        If USIB_IO_error = True Then
            GetDataFromDevice = False
            Exit Function
        End If

        Try
            If HIDDUT.IsOpen Then
                HIDDUTData = HIDDUT.Read(250)       'Get input report (timeout = 250mSec ?!?!?)
                For lp = 0 To 64                    'copy the buffers
                    DataFromDevice(lp) = HIDDUTData.Data(lp)
                Next lp
                GetDataFromDevice = True
            Else
                GetDataFromDevice = False
            End If

        Catch ex As Exception
            DisplayException("USB-IO", ex)
            GetDataFromDevice = False
            'Throw
        End Try
    End Function

    'This routine send a command to the USB device
    Public Function SendCommand(ByVal command As Byte) As Boolean
        DataToDevice(0) = 0                 'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
        DataToDevice(1) = command           'this is the command, which is used in the device to determine the action to be taken on the next request of data
        SendCommand = SendDataToDevice()    'send the data to the USB device (copy the result true/false)
    End Function

    'this will read 32 bytes from flash for the monitor view (shows HEX and ASCII notion 16 bytes per line)
    'the programming below could be more efficient for more then 32 bytes, but since that will never be used as the HID packet can only contain up to 64 bytes
    'and we loose some bytes due to overhead, the practical max. is 32. Which (for this case) justifies the programming technique below
    Public Function Read_32Bytes_From_Flash(ByVal adr2 As Byte, ByVal adr1 As Byte, ByVal adr0 As Byte) As Boolean
        DataToDevice(0) = 0                     'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
        DataToDevice(1) = CMD_READ_32BYTES_FROM_FLASH   'this is the command, which is used in the device to determine the action to be taken on the next request of data
        DataToDevice(2) = adr2
        DataToDevice(3) = adr1
        DataToDevice(4) = adr0
        SendDataToDevice()                      'send the data to the USB device

        If (GetDataFromDevice() And DataFromDevice(1) = CMD_READ_32BYTES_FROM_FLASH) Then
            Read_32Bytes_From_Flash = True
        Else
            Read_32Bytes_From_Flash = False
        End If
    End Function

    'this will read the max amount of bytes (as defined by PACKET_PAYLOADSIZE_DATAFILE) from flash
    Public Function Read_Bytes_From_Flash(ByVal adr2 As Byte, ByVal adr1 As Byte, ByVal adr0 As Byte) As Boolean
        DataToDevice(0) = 0                         'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
        DataToDevice(1) = CMD_READ_DATA_FROM_FLASH  'this is the command, which is used in the device to determine the action to be taken on the next request of data
        DataToDevice(2) = adr2
        DataToDevice(3) = adr1
        DataToDevice(4) = adr0
        SendDataToDevice()                      'send the data to the USB device

        If (GetDataFromDevice() And DataFromDevice(1) = CMD_READ_DATA_FROM_FLASH) Then
            Read_Bytes_From_Flash = True
        Else
            Read_Bytes_From_Flash = False
        End If
    End Function

    Public Function Read_Byte_From_EEPROM(ByVal adr As Byte) As Byte
        DataToDevice(0) = 0                     'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
        DataToDevice(1) = CMD_READ_EEPROM       'this is the command, which is used in the device to determine the action to be taken on the next request of data
        DataToDevice(2) = adr
        SendDataToDevice()                      'send the data to the USB device

        If (GetDataFromDevice() And DataFromDevice(1) = CMD_READ_EEPROM) Then
            Read_Byte_From_EEPROM = DataFromDevice(2)
        Else
            MessageBox.Show("Problem reading EEPROM data", "Problem during EEPROM read", MessageBoxButtons.OK)
            Read_Byte_From_EEPROM = 0
        End If

    End Function

    Public Function Write_Byte_To_EEPROM(ByVal adr As Byte, ByVal data As Byte) As Byte
        DataToDevice(0) = 0                     'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
        DataToDevice(1) = CMD_WRITE_EEPROM       'this is the command, which is used in the device to determine the action to be taken on the next request of data
        DataToDevice(2) = adr
        DataToDevice(3) = data
        SendDataToDevice()                      'send the data to the USB device

        If (GetDataFromDevice() And DataFromDevice(1) = CMD_WRITE_EEPROM) Then
            'Debug.Print("Write byte to EEPROM succesfull")
            Return (True)
        Else
            Debug.Print("Write byte to EEPROM failed at address:" & adr.ToString("X2"))
            Return (False)
        End If
    End Function

    Public Function Read_RemaningSpace() As UInteger
        DataToDevice(0) = 0                         'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
        DataToDevice(1) = CMD_GETREMAININGSPACE     'request remaingspace on flash memory

        'send the data to the USB device and wait for acknowledge
        If (SendDataToDevice() And GetDataFromDevice() And DataFromDevice(1) = CMD_GETREMAININGSPACE) Then

            Read_RemaningSpace = DataFromDevice(2) + (DataFromDevice(3) * 256)
        Else
            MessageBox.Show("Problem reading file info (required for directory information)", "Problem during reading of file info", MessageBoxButtons.OK)
            Read_RemaningSpace = 0  'return 0 when failed
        End If
    End Function

    'find the first or next file of the specified type
    Public Function Read_FileInfo(ByVal search_mode As Byte, ByVal search_type As Byte) As Boolean
        Dim lp As Integer
        Dim pointer As Integer
        Dim number_of_4K_blocks As Integer
        Dim TS_YY__ As Byte
        Dim TS___YY As Byte
        Dim TS_month As Byte
        Dim TS_day As Byte
        Dim TS_hour As Byte
        Dim TS_minute As Byte
        Dim datestamp_str As String
        Dim timestamp_str As String

        FileInfo_CompModel = (search_type And &HF0) >> 4 'the upper nibble indicates the computermodel (mask out lower niblle and shift higher 4 bits to the right)
        DataToDevice(0) = 0                         'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
        DataToDevice(1) = CMD_READ_FILE_INFO        'request file info so we can build and show the file systems directory information
        DataToDevice(2) = search_mode               '0=first file, 1=next file
        'Debug.Print("Read_FileInfo: search_type=" & search_type.ToString)
        DataToDevice(3) = search_type               'the type of file (system file, program file, etc.)

        'send the data to the USB device and wait for acknowledge
        If (SendDataToDevice() And GetDataFromDevice() And DataFromDevice(1) = CMD_READ_FILE_INFO) Then
            If DataFromDevice(2) = 0 Then  'definition are 0=FALSE (no file of requested type has been found) 1=TRUE (file of requested type has been found)
                Read_FileInfo = False
            Else
                Read_FileInfo = True
                FileInfo_Name = ""
                For lp = 0 To 31 'this loops runs 32 times (=filenamelength)
                    pointer = lp + 3
                    FileInfo_Name = FileInfo_Name & ASCII_table(DataFromDevice(pointer))
                Next

                'Debug.Print(DataFromDevice(35).ToString("X2") & " " & DataFromDevice(36).ToString("X2") & " " & DataFromDevice(37).ToString("X2"))
                number_of_4K_blocks = ((DataFromDevice(35) * 65536) + (DataFromDevice(36) * 256) + DataFromDevice(37)) / BytesPerBlock
                TS_YY__ = DataFromDevice(38)
                TS___YY = DataFromDevice(39)
                TS_month = DataFromDevice(40)
                TS_day = DataFromDevice(41)
                TS_hour = DataFromDevice(42)
                TS_minute = DataFromDevice(43)
                '... = DataFromDevice(44) 'in case of TAP file, this is the indicator for the tap file version
                '... = DataFromDevice(45) 'in case of TAP file, this is the indicator for the compression type
                '... = DataFromDevice(46) 'in case of TAP file, this is the indicator for the escape code
                '... = DataFromDevice(47) 'in case of TAP file, filesize uncompressed MSB
                '... = DataFromDevice(48) 'in case of TAP file, filesize uncompressed .SB
                '... = DataFromDevice(49) 'in case of TAP file, filesize uncompressed LSB
                datestamp_str = TS_YY__.ToString("D2") & TS___YY.ToString("D2") & "-" & TS_month.ToString("D2") & "-" & TS_day.ToString("D2")
                timestamp_str = TS_hour.ToString("D2") & ":" & TS_minute.ToString("D2")


                FileInfo_BlockSize = number_of_4K_blocks
                FileInfo_Type = "systemf. (.SYS)"
                FileInfo_AdrLast = "$" & ((DataFromDevice(47) + (DataFromDevice(48) * 256)) - 1).ToString("X4") 'value is little endian, the address stored is not the last address but the first address after the last byte, so we need to subtract 1 to get the real last address of the program
                FileInfo_AdrFirst = "$" & (DataFromDevice(49) + (DataFromDevice(50) * 256)).ToString("X4")  'value is little endian
                FileInfo_Date = datestamp_str
                FileInfo_Time = timestamp_str
                FileInfo_FirstBlock = "$" & ((DataFromDevice(51) * 256) + DataFromDevice(52)).ToString("X4") & "00" 'value is big endian
                FileInfo_RealSize = "-"

                Select Case (search_type And &HF)
                    Case FILETYPE_SYS
                        FileInfo_Type = FILETYPE_SYS.ToString("d2") & ":systemfile (.SYS)"
                        FileInfo_AdrFirst = "-"
                        FileInfo_AdrLast = "-"

                    Case FILETYPE_EEP
                        FileInfo_Type = FILETYPE_EEP.ToString("d2") & ":settingfile (.EEP)"
                        FileInfo_AdrFirst = "-"
                        FileInfo_AdrLast = "-"

                    Case FILETYPE_MENU
                        FileInfo_Type = FILETYPE_MENU.ToString("d2") & ":configprogram (.PRG)"

                    Case FILETYPE_PRG
                        FileInfo_Type = FILETYPE_PRG.ToString("d2") & ":userfile (.PRG)"

                    Case FILETYPE_TAP
                        If (DataFromDevice(45) = 1) Then 'value 1 indicates no compression used
                            FileInfo_Type = FILETYPE_TAP.ToString("d2") & ":tapefile (.TAP)"
                        Else
                            FileInfo_Type = FILETYPE_TAP.ToString("d2") & ":tape compressed(.TAP)"
                        End If
                        FileInfo_RealSize = ((DataFromDevice(47) * 256 * 256) + (DataFromDevice(48) * 256) + DataFromDevice(49)).ToString
                        FileInfo_AdrFirst = "-"
                        FileInfo_AdrLast = "-"

                    Case FILETYPE_VOC
                        FileInfo_Type = FILETYPE_VOC.ToString("d2") & ":vocabululary (.VOC)"
                        FileInfo_AdrFirst = "-"
                        FileInfo_AdrLast = "-"

                    Case FILETYPE_WAV
                        FileInfo_Type = FILETYPE_WAV.ToString("d2") & ":audiofile (.WAV)"
                        FileInfo_AdrFirst = "-"
                        FileInfo_AdrLast = "-"

                    Case FILETYPE_DAT
                        FileInfo_Type = FILETYPE_DAT.ToString("d2") & ":datafile (.DAT)"
                        FileInfo_RealSize = ((DataFromDevice(47) * 256 * 256) + (DataFromDevice(48) * 256) + DataFromDevice(49)).ToString
                        FileInfo_AdrFirst = "-"
                        FileInfo_AdrLast = "-"

                End Select
            End If
        Else
            MessageBox.Show("Problem reading file info (required for directory information)", "Problem during reading of file info", MessageBoxButtons.OK)
            Read_FileInfo = False
        End If

    End Function

    ''thanks to http://unusedino.de/ec64/technical/formats/d64.html
    ''this routine will transfer data from a disc and saves it to a D64 file
    'Public Function TransferDiscImage(ByVal name_string As String) As Boolean
    '    Dim Track As Byte = 1
    '    Dim Sector As Byte = 0
    '    Dim BlockData_pntr As Byte = 0
    '    Dim max_sector As Integer = 683 '638 sectors on a 35 track disc)
    '    Dim sector_count As Integer = 0 'this is a counter used for the progressbar
    '    Dim TrackSector_table() As Byte = {21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 19, 19, 19, 19, 18, 18, 18, 18, 18, 18, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17}

    '    Dim lp As Byte
    '    Dim program_lp As UInteger
    '    Dim exit_loop As Boolean = False
    '    Dim wFile As System.IO.FileStream

    '    Dim pgrBar As New frm_ProgressBar
    '    pgrBar.Init("Extracting file from from Cassiopei's Flash memory", 0, max_sector)
    '    pgrBar.Show()

    '    'todo:
    '    'lees een sector (track 1 sector 0) en save die to disk
    '    'als dit werkt maak dan een loop die de hele disk uitleest...


    '    DataToDevice(0) = 0                          'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
    '    DataToDevice(1) = CMD_DISC_READ_TRACK_SECTOR 'request block to be found at TRACK and SECTOR
    '    DataToDevice(2) = Track
    '    DataToDevice(3) = Sector

    '    If (SendDataToDevice() And GetDataFromDevice() And DataFromDevice(1) = CMD_DISC_READ_TRACK_SECTOR) Then
    '        wFile = New FileStream(name_string, FileMode.Create)            'open the file to which we want to write
    '        While (exit_loop = False)
    '            Application.DoEvents()        'update the GUI!!!

    '            '    'fill the USB buffer with the data in order to request a packet of data
    '            DataToDevice(0) = 0                         'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
    '            DataToDevice(1) = CMD_DISC_GET_BLOCK_DATA   'request reading of current file
    '            BlockData_pntr = 0
    '            If (SendDataToDevice() And GetDataFromDevice() And DataFromDevice(1) <> CMD_DISC_GET_BLOCK_DATA) Then
    '                '        Debug.Print("1=" & DataFromDevice(1).ToString("X2"))
    '                '        MessageBox.Show("File extraction has not received the expected response of the slave device", "Problem during extraction of file", MessageBoxButtons.OK)
    '                '        TransferDiscImage = False 'something went wrong!
    '                        exit_loop = True     'error encountered, so we stop the loop
    '                '    Else
    '                For lp = 0 To 31

    '                    '                Exit For
    '                    '            End If
    '                    wFile.WriteByte(DataFromDevice(2 + lp))
    '                Next lp
    '                exit_loop = True    'end of transfer reached, so we stop the loop
    '                '       TransferDiscImage = True          'so far so good...
    '            End If
    '        End While


    '    End If

    '    sector_count = sector_count + 1 'another succesfull block transfer, increment sector counter
    '    pgrBar.Value(sector_count)      'and use this to update the progressbar


    '    wFile.Close()       'close the file
    '    pgrBar.Dispose()    'close the progressbar window

    'End Function

    'this routine can copy a file from the cassiopei file system to a computer
    Public Function Extract_file(ByVal index As Byte, ByVal type As Byte, ByVal name_string As String, ByVal firstaddress As UInteger, ByVal lastaddress As UInteger) As Boolean
        Const first_file As Byte = 0
        Const next_file As Byte = 1
        Dim exit_loop As Boolean = False
        Dim lp As Byte
        Dim program_lp As UInteger
        Dim value() As Byte
        Dim search As Byte
        Dim search_result As String
        Dim wFile As System.IO.FileStream

        Debug.Print("first address=" & firstaddress & ", last address=" & lastaddress & ", index=" & index & ", type=" & type)
        search = first_file
        For lp = 0 To index
            search_result = Read_FileInfo(search, type)         'search for the first/next file
            If (search_result = False) Then                      'when nothing was found, quit searching for this filetype
                Debug.Print("Not enough files to reach the requested index")
                Extract_file = False
                Exit Function
            End If
            search = next_file
        Next lp

        'transfer the data
        '-----------------
        lastaddress = lastaddress + 2   'the size of the file is 2 bytes larger then the places it takes in the CBM's RAM, because there are 2 bytes that tells the CBM
        'where to put this data. Those 2 bytes are the startaddress, so we must copy to more bytes from flash otherwise our file would not be complete !!!

        Dim pgrBar As New frm_ProgressBar
        pgrBar.Init("Extracting file from from Cassiopei's Flash memory", firstaddress, lastaddress)
        pgrBar.Show()
        program_lp = firstaddress
        wFile = New FileStream(name_string, FileMode.Create)            'open the file to which we want to write
        If ((type And &HF) = FILETYPE_PRG) Then       'only for a PRG this information needs to be written to the file
            value = BitConverter.GetBytes(firstaddress)                     'convert the startaddress of the program to a value of a byte type
            wFile.WriteByte(value(0))       'low byte of address, first 2 bytes of a .PRG file are the start address of the program (the addres to which it needs to be loaded to in order to use it) all other bytes are used for the file itself
            wFile.WriteByte(value(1))       'high byte of address, first 2 bytes of a .PRG file are the start address of the program (the addres to which it needs to be loaded to in order to use it) all other bytes are used for the file itself
        End If

        While (exit_loop = False)
            Application.DoEvents()        'update the GUI!!!

            'fill the USB buffer with the data in order to request a packet of data
            DataToDevice(0) = 0                         'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
            DataToDevice(1) = CMD_READ_CURRENT_FILE     'request reading of current file
            If (SendDataToDevice() And GetDataFromDevice() And DataFromDevice(1) <> CMD_READ_CURRENT_FILE) Then
                Debug.Print("1=" & DataFromDevice(1).ToString("X2"))
                MessageBox.Show("File extraction has not received the expected response of the slave device", "Problem during extraction of file", MessageBoxButtons.OK)
                Extract_file = False 'something went wrong!
                exit_loop = True     'error encountered, so we stop the loop
            Else
                For lp = 0 To (PACKET_PAYLOADSIZE_USERFILE - 1)
                    program_lp = program_lp + 1
                    If (program_lp = lastaddress) Then
                        exit_loop = True    'end of transfer reached, so we stop the loop
                        Exit For
                    End If
                    wFile.WriteByte(DataFromDevice(2 + lp))
                    pgrBar.Value(program_lp)
                Next lp
                Extract_file = True          'so far so good...
            End If
        End While
        wFile.Close()       'close the file
        pgrBar.Dispose()    'close the progressbar window
    End Function

    'this functine searches for the ...th file of the type ...
    Public Function Delete_file(ByVal index As Byte, ByVal type As Byte) As Boolean
        Const first_file As Byte = 0
        Const next_file As Byte = 1
        Dim lp As Byte
        Dim search As Byte
        Dim search_result As Boolean

        Dim pgrBar As New frm_ProgressBar
        pgrBar.Init("Deleting file from Flash (patience please...)", 0, 10)
        pgrBar.Value(10)
        pgrBar.Show()
        Application.DoEvents()      'update the GUI!!!

        'Debug.Print("index=" & index & ", type=" & type)
        search = first_file
        For lp = 0 To index
            search_result = Read_FileInfo(search, type) 'search for the first/next file
            If (search_result = False) Then             'when nothing was found, quit searching for this filetype
                Debug.Print("Not enough files to reach the requested index")
                pgrBar.Dispose()
                Delete_file = False
                Exit Function
            End If
            search = next_file
        Next lp

        'fill the USB buffer with the data
        DataToDevice(0) = 0                         'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
        DataToDevice(1) = CMD_DELETE_CURRENT_FILE   'request delete of current file

        'send the data to the USB device and wait for acknowledge
        If (SendDataToDevice() And GetDataFromDevice() And DataFromDevice(1) = CMD_DELETE_CURRENT_FILE) Then
            Debug.Print("Delete succesfull")
        Else
            MessageBox.Show("Delete has not received the expected response of the slave device", "Problem during deleting of file", MessageBoxButtons.OK)
        End If

        pgrBar.Dispose()
        Delete_file = True
    End Function

    'this functine searches for the ...th file of the type ...
    Public Function RealFileSize(ByVal index As Byte, ByVal type As Byte) As Integer
        Dim pgrBar As New frm_ProgressBar
        pgrBar.Init("Scanning filechain (patience please...)", 0, 10)
        pgrBar.Value(10)
        pgrBar.Show()
        Application.DoEvents()      'update the GUI!!!

        'fill the USB buffer with the data
        DataToDevice(0) = 0                         'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
        DataToDevice(1) = CMD_COUNT_REALSIZE        'request real size of current file
        DataToDevice(2) = index
        DataToDevice(3) = type

        'send the data to the USB device and wait for acknowledge
        If (SendDataToDevice() And GetDataFromDevice() And DataFromDevice(1) = CMD_COUNT_REALSIZE) Then
            RealFileSize = DataFromDevice(2) + (DataFromDevice(3) * 256) 'little endian
        Else
            MessageBox.Show("RealFileSize has not received the expected response of the slave device", "Problem requesting real file size", MessageBoxButtons.OK)
            RealFileSize = 0
        End If

        pgrBar.Dispose()
    End Function

    'we calculate the filesize in blocks and store that value into the filesize registers
    'the filesize in blocks is more then the real filesize due to the overhead of the first block which contains the fileinfo (name, timestamp, etc) this adds 44 extra bytes
    Private Function Calculate_FilesizeSizeInBlocks(ByVal filesize As UInteger, ByVal payloadsize As UInteger) As UInteger
        Dim numberofpackages As UInteger
        Dim extra_padding_bytes As UInteger

        'calculate the number of packages that need to be transmitted
        If (filesize Mod payloadsize = 0) Then
            numberofpackages = filesize \ payloadsize
        Else
            numberofpackages = (filesize \ payloadsize) + 1
        End If
        Debug.Print("Transmitting the file using " & numberofpackages & " packages of " & PACKET_PAYLOADSIZE_USERFILE & " bytes each")
        extra_padding_bytes = (numberofpackages * PACKET_PAYLOADSIZE_USERFILE) - filesize
        Debug.Print("number of extra bytes added to the file (extra_padding bytes) are " & extra_padding_bytes)


        If (((filesize + BytesPerFileheader + 1 + extra_padding_bytes) Mod BytesPerBlock) = 0) Then
            Calculate_FilesizeSizeInBlocks = ((filesize + BytesPerFileheader + extra_padding_bytes) \ BytesPerBlock) * BytesPerBlock
        Else
            Calculate_FilesizeSizeInBlocks = (((filesize + BytesPerFileheader + extra_padding_bytes) \ BytesPerBlock) + 1) * BytesPerBlock
        End If

        Debug.Print("The number of used blocks =" & Calculate_FilesizeSizeInBlocks / BytesPerBlock)
    End Function


    'This routine sends the specifications of a file to the USB device, followed by the filedata (if larger then .. bytes data is spread over multiple packets)
    'The filename is truncated/filled with spaces to ... characters
    Public Sub Send_user_File(ByVal filepath As String, ByVal filetype As Byte)
        Dim filename As String
        Dim lp As Byte
        Dim low_byte As Byte
        Dim high_byte As Byte
        Dim input_filesize As UInteger
        Dim filesizeinblocks As Long
        Dim value() As Byte
        Dim FirstAddress As UInteger
        Dim LastAddress As UInteger
        Dim packet_lp As Byte
        Dim program_lp As Double
        Dim Now As DateTime = DateTime.Now

        filename = System.IO.Path.GetFileName(filepath).ToUpper 'remove the path, leaving only the pure filename (which is exactly what we want), convert also to upper case to make it readable on the C64
        Debug.Print("filename = " & filename & "   filepath=" & filepath)

        'open file and gather data
        Using fs As New FileStream(filepath, FileMode.Open)
            input_filesize = fs.Length
            fs.Position = 0
            Using br As New BinaryReader(fs)

                'transfer the file details
                '-------------------------
                low_byte = br.ReadByte  'read low byte of start address
                high_byte = br.ReadByte  'read high byte of start address

                FirstAddress = (high_byte * 256) + low_byte     'first memory address of program when loaded into C64
                LastAddress = FirstAddress + input_filesize - 2 'last memory address of program when loaded into C64 (filesize-2 because the file used has the first two bytes used for the definition of the LOAD address and is nor really part of the program that is to be transferred)

                'fill the USB buffer with the data
                DataToDevice(0) = 0                         'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
                DataToDevice(1) = CMD_PREPARE_FILE_FROM_PC  'this is the command, which is used in the device to determine the action to be taken on the next request of data
                DataToDevice(2) = filetype                  'save the filetype as indicated by the caller of this routine

                For lp = 0 To 31                            'filename is 32 bytes
                    If lp < filename.Length Then
                        DataToDevice(lp + 3) = AscW(filename(lp))
                    Else
                        DataToDevice(lp + 3) = 32 'fill empty char position with spaces
                    End If
                Next lp


                filesizeinblocks = Calculate_FilesizeSizeInBlocks(input_filesize, PACKET_PAYLOADSIZE_USERFILE)
                value = BitConverter.GetBytes(filesizeinblocks)
                'Debug.Print("size=" & input_filesize & " nextblockaddress=" & value(2).ToString("X2") & "," & value(1).ToString("X2") & "," & value(0).ToString("X2"))
                DataToDevice(35) = value(2)   'filesize (rounded to a 4K boundry) MSB
                DataToDevice(36) = value(1)   '.SB
                DataToDevice(37) = value(0)   'LSB
                DataToDevice(38) = Now.Year \ 100
                DataToDevice(39) = Now.Year Mod 100
                DataToDevice(40) = Now.Month
                DataToDevice(41) = Now.Day
                DataToDevice(42) = Now.Hour
                DataToDevice(43) = Now.Minute
                DataToDevice(44) = 1 'additional info <<for future use>>
                DataToDevice(45) = 1 'additional info <<for future use>>
                DataToDevice(46) = 1 'additional info <<for future use>>

                DataToDevice(47) = LastAddress Mod 256        'low byte of last memory address of program when loaded into C64
                DataToDevice(48) = LastAddress >> 8           'high byte of last memory address of program when loaded into C64
                DataToDevice(49) = FirstAddress Mod 256       'low byte of first memory address of program when loaded into C64 (aka load address)
                DataToDevice(50) = FirstAddress >> 8          'high byte of first memory address of program when loaded into C64 (aka load address)

                'send the data to the USB device and wait for acknowledge
                If (SendDataToDevice() And GetDataFromDevice() And DataFromDevice(1) = CMD_PREPARE_FILE_FROM_PC) Then
                    'Debug.Print("Send_PRG_File 'file info package' send succesfully")
                Else
                    MessageBox.Show("Send_user_File 'file info package' has not received the expected response of the slave device", "Problem during sending of file details", MessageBoxButtons.OK)
                    Exit Sub
                End If

                'transfer the data
                '-----------------

                Dim pgrBar As New frm_ProgressBar
                pgrBar.Init("Copying data to Cassiopei's Flash memory", FirstAddress, LastAddress)
                pgrBar.Show()

                program_lp = FirstAddress
                While program_lp < LastAddress          'copy all the data from the file
                    Application.DoEvents()              'update the GUI!!!
                    DataToDevice(0) = 0                 'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
                    DataToDevice(1) = CMD_FILE_FROM_PC  'this is the command, which is used in the device to determine the action to be taken on the next request of data

                    For packet_lp = 0 To (PACKET_PAYLOADSIZE_USERFILE - 1)
                        If program_lp < LastAddress Then
                            DataToDevice(2 + packet_lp) = br.ReadByte  'read data byte from file and copy to the buffer
                            'Debug.Print(program_lp & " " & packet_lp & " = " & DataToDevice(2 + packet_lp).ToString("X2"))
                            program_lp = program_lp + 1
                            pgrBar.Value(program_lp)
                        Else
                            DataToDevice(2 + packet_lp) = 0    'fill packet with 0's, technically not really nessecary but it is more ellagant and easier to read if we need to debug it on the receiving end
                        End If
                    Next packet_lp


                    'send the data to the USB device and wait for acknowledge
                    If (SendDataToDevice() And GetDataFromDevice() And DataFromDevice(1) = CMD_FILE_FROM_PC) Then
                        'Debug.Print("Send_PRG_file 'data package' send succesfully")
                    Else
                        MessageBox.Show("Send_user_File 'data package' has not received the expected response of the slave device", "Problem during sending of file data", MessageBoxButtons.OK)
                        pgrBar.Dispose()
                        Exit Sub
                    End If
                End While
                Debug.Print("Send_user_File has send file succesfully")
                pgrBar.Dispose()
            End Using
        End Using
    End Sub

    'This routine sends the specifications of a file to the USB device, followed by the filedata (if larger then .. bytes data is spread over multiple packets)
    'The filename is truncated/filled with spaces to ... characters
    Public Sub Send_TAP_File(ByVal filepath As String, ByVal filetype As Byte, ByVal filecompress As Boolean)
        Dim filename As String
        Dim uncompressedfilesize As Long
        Dim lp As Byte
        Dim compressed As Boolean
        Dim input_filesize As UInteger
        Dim filesizeinblocks As Long
        Dim value() As Byte
        Dim packet_lp As Byte
        Dim program_lp As UInteger
        Dim Now As DateTime = DateTime.Now

        filename = System.IO.Path.GetFileName(filepath).ToUpper 'remove the path, leaving only the pure filename (which is exactly what we want), convert also to upper case to make it readable on the C64
        Debug.Print("filename = " & filename & "   filepath=" & filepath)

        'check if file is usable
        If (frm_Main.clsTAP.Init_TAP_file(filepath, filecompress) = False) Then
            Exit Sub 'exit when the TAP file is not suported
        End If

        uncompressedfilesize = frm_Main.clsTAP.Datasize     'get the uncompressed fileszise (actually datasize) this is the value we require for the tape counter

        'check if file is compressable and if so then make a temporary file that holds the compressed data
        compressed = False
        If (filecompress = True) Then                           'when compression is enabled (checkbox in settingscreen)...
            If (frm_Main.clsTAP.Compressed = True) Then         'and the file itself can be compressed...
                compressed = True                               'then the file will be handled as a compressed file
                filepath = frm_Main.clsTAP.CompressedFilename   'the code below must use the temporary file with the compressed data and send that to the Cassiopei
            End If
        End If

        Using fs As New FileStream(filepath, FileMode.Open)
            Using br As New BinaryReader(fs)
                'open file and gather data
                If (compressed = True) Then
                    fs.Position = 0                 'the compressed file already has the header of the TAP file removed, so there is no need to skip data
                    input_filesize = frm_Main.clsTAP.CompressedFilesize
                Else
                    fs.Position = 16                'file details are 16 bytes (we may skip them as Show_TAP_info allready processed these values), the next 4 bytes contain the blocksize (or size of the TAP file data)
                    input_filesize = br.ReadByte + (256 * br.ReadByte) + (256 * 256 * br.ReadByte) + (256 * 256 * 256 * br.ReadByte)
                    Debug.Print("TAP file input filesize =" & input_filesize)
                End If

                'fill the USB buffer with the data
                DataToDevice(0) = 0                         'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
                DataToDevice(1) = CMD_PREPARE_FILE_FROM_PC  'this is the command, which is used in the device to determine the action to be taken on the next request of data
                DataToDevice(2) = filetype                  'save the filetype

                For lp = 0 To 31                            'filename is 32 bytes
                    If lp < filename.Length Then
                        DataToDevice(lp + 3) = AscW(filename(lp))
                    Else
                        DataToDevice(lp + 3) = 32 'fill empty char position with spaces
                    End If
                Next lp


                filesizeinblocks = Calculate_FilesizeSizeInBlocks(input_filesize, PACKET_PAYLOADSIZE_USERFILE)
                value = BitConverter.GetBytes(filesizeinblocks)
                'Debug.Print("size=" & input_filesize & " nextblockaddress=" & value(2).ToString("X2") & "," & value(1).ToString("X2") & "," & value(0).ToString("X2"))
                DataToDevice(35) = value(2)   'filesize (rounded to a 4K boundry) MSB
                DataToDevice(36) = value(1)   '.SB
                DataToDevice(37) = value(0)   'LSB
                DataToDevice(38) = Now.Year \ 100
                DataToDevice(39) = Now.Year Mod 100
                DataToDevice(40) = Now.Month
                DataToDevice(41) = Now.Day
                DataToDevice(42) = Now.Hour
                DataToDevice(43) = Now.Minute
                DataToDevice(44) = frm_Main.clsTAP.Version      'Version info, because we need to indicate the type of .TAP file
                If (compressed = True) Then
                    DataToDevice(45) = &HC0                     'this indicates the used compression format (0xC0 = version 0)
                    DataToDevice(46) = frm_Main.clsTAP.Escapecode   'the escape code as used in this compressed file
                    value = BitConverter.GetBytes(uncompressedfilesize)
                Else
                    DataToDevice(45) = 1                        'this is the value that an uncompressed .TAP file must have in the Cassiopei filesystem
                    DataToDevice(46) = 1                        'this is the value that an uncompressed .TAP file must have in the Cassiopei filesystem
                End If
                DataToDevice(47) = value(2) 'Uncompressed filesize MSB (this value is more accurate then the blocksize value, which is always larger thenthe real filesize)
                DataToDevice(48) = value(1) 'Uncompressed filesize .SB (therefore it makes sense to add this information to both compressed and uncompressed files)
                DataToDevice(49) = value(0) 'Uncompressed filesize LSB
                DataToDevice(50) = 0        'this info is not available

                'send the data to the USB device and wait for acknowledge
                If (SendDataToDevice() And GetDataFromDevice() And DataFromDevice(1) = CMD_PREPARE_FILE_FROM_PC) Then
                    'Debug.Print("Send_PRG_File 'file info package' send succesfully")
                Else
                    MessageBox.Show("Send_TAP_File 'file info package' has not received the expected response of the slave device", "Problem during sending of file details", MessageBoxButtons.OK)
                    Exit Sub
                End If

                'transfer the data
                '-----------------
                Dim pgrBar As New frm_ProgressBar
                pgrBar.Init("Copying data to Cassiopei's Flash memory", 0, input_filesize)
                pgrBar.Show()

                program_lp = 0
                While program_lp < input_filesize 'copy all the data from the file
                    Application.DoEvents()      'update the GUI!!!
                    DataToDevice(0) = 0                 'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
                    DataToDevice(1) = CMD_FILE_FROM_PC  'this is the command, which is used in the device to determine the action to be taken on the next request of data

                    For packet_lp = 0 To (PACKET_PAYLOADSIZE_USERFILE - 1)
                        If program_lp < input_filesize Then
                            DataToDevice(2 + packet_lp) = br.ReadByte  'read data byte from file and copy to the buffer
                            'Debug.Print(program_lp & " " & packet_lp & " = " & DataToDevice(2 + packet_lp).ToString("X2"))
                            program_lp = program_lp + 1
                            pgrBar.Value(program_lp)
                        Else
                            DataToDevice(2 + packet_lp) = 0    'fill packet with 0's, technically not really required but it is more ellegant and easier to read if we need to debug it on the receiving end
                        End If
                    Next packet_lp

                    'Dim tmp_str As String
                    'tmp_str = program_lp.ToString("X6") & ": "
                    'For lp = 0 To PACKET_PAYLOADSIZE_USERFILE
                    '    tmp_str = tmp_str & DataToDevice(lp).ToString("X2")
                    'Next lp
                    'Debug.Print(tmp_str)

                    'send the data to the USB device and wait for acknowledge
                    If (SendDataToDevice() And GetDataFromDevice() And DataFromDevice(1) = CMD_FILE_FROM_PC) Then
                        'Debug.Print("Send_PRG_file 'data package' send succesfully")
                    Else
                        MessageBox.Show("Send_TAP_File 'data package' has not received the expected response of the slave device", "Problem during sending of file data", MessageBoxButtons.OK)
                        pgrBar.Dispose()
                        Exit Sub
                    End If
                End While
                pgrBar.Dispose()
                Debug.Print("Send_TAP_File has send file succesfully")
            End Using
        End Using
    End Sub

    'This routine sends the specifications of a file to the USB device, followed by the filedata (if larger then .. bytes data is spread over multiple packets)
    'The filename is truncated/filled with spaces to ... characters
    Public Sub Send_WAV_File(ByVal filepath As String)
        Dim filename As String
        Dim lp As Byte
        Dim input_filesize As UInteger
        Dim filesizeinblocks As Long
        Dim value() As Byte
        Dim packet_lp As Byte
        Dim program_lp As UInteger
        Dim Now As DateTime = DateTime.Now

        filename = System.IO.Path.GetFileName(filepath).ToUpper 'remove the path, leaving only the pure filename (which is exactly what we want), convert also to upper case to make it readable on the C64
        Debug.Print("filename = " & filename & "   filepath=" & filepath)

        'open file and gather data
        Using fs As New FileStream(filepath, FileMode.Open)
            input_filesize = fs.Length
            fs.Position = 0
            Using br As New BinaryReader(fs)
                fs.Position = 0

                'transfer the file details
                '-------------------------
                Debug.Print("WAV file input filesize =" & input_filesize)

                Dim pgrBar As New frm_ProgressBar
                pgrBar.Init("Copying file to Cassiopei's Flash memory", 0, input_filesize)
                pgrBar.Show()

                'fill the USB buffer with the data
                DataToDevice(0) = 0                         'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
                DataToDevice(1) = CMD_PREPARE_FILE_FROM_PC  'this is the command, which is used in the device to determine the action to be taken on the next request of data
                DataToDevice(2) = FILETYPE_WAV              'save the filetype

                For lp = 0 To 31                            'filename is 32 bytes
                    If lp < filename.Length Then
                        DataToDevice(lp + 3) = AscW(filename(lp))
                    Else
                        DataToDevice(lp + 3) = 32 'fill empty char position with spaces
                    End If
                Next lp


                filesizeinblocks = Calculate_FilesizeSizeInBlocks(input_filesize, PACKET_PAYLOADSIZE_USERFILE)
                value = BitConverter.GetBytes(filesizeinblocks)
                'Debug.Print("size=" & input_filesize & " nextblockaddress=" & value(2).ToString("X2") & "," & value(1).ToString("X2") & "," & value(0).ToString("X2"))
                DataToDevice(35) = value(2)   'filesize (rounded to a 4K boundry) MSB
                DataToDevice(36) = value(1)   '.SB
                DataToDevice(37) = value(0)   'LSB
                DataToDevice(38) = Now.Year \ 100
                DataToDevice(39) = Now.Year Mod 100
                DataToDevice(40) = Now.Month
                DataToDevice(41) = Now.Day
                DataToDevice(42) = Now.Hour
                DataToDevice(43) = Now.Minute
                DataToDevice(44) = &H80 '<<for future use>>
                DataToDevice(45) = &H80 '<<for future use>>
                DataToDevice(46) = &H80 '<<for future use>>

                DataToDevice(47) = &H80 '<<for future use>>
                DataToDevice(48) = &H80 '<<for future use>>
                DataToDevice(49) = &H80 '<<for future use>>
                DataToDevice(50) = &H80 '<<for future use>>

                'send the data to the USB device and wait for acknowledge
                If (SendDataToDevice() And GetDataFromDevice() And DataFromDevice(1) = CMD_PREPARE_FILE_FROM_PC) Then
                    'Debug.Print("Send_PRG_File 'file info package' send succesfully")
                Else
                    MessageBox.Show("Send_WAV_File 'file info package' has not received the expected response of the slave device", "Problem during sending of file details", MessageBoxButtons.OK)
                    pgrBar.Dispose()
                    Exit Sub
                End If

                'transfer the data
                '-----------------
                program_lp = 0
                While program_lp < input_filesize       'copy all the data from the file
                    Application.DoEvents()              'update the GUI!!!
                    DataToDevice(0) = 0                 'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
                    DataToDevice(1) = CMD_FILE_FROM_PC  'this is the command, which is used in the device to determine the action to be taken on the next request of data

                    For packet_lp = 0 To (PACKET_PAYLOADSIZE_USERFILE - 1)
                        If program_lp < input_filesize Then
                            DataToDevice(2 + packet_lp) = br.ReadByte  'read data byte from file and copy to the buffer
                            'Debug.Print(program_lp & " " & packet_lp & " = " & DataToDevice(2 + packet_lp).ToString("X2"))
                            program_lp = program_lp + 1

                            If (DataToDevice(2 + packet_lp) = 0) Then
                                DataToDevice(2 + packet_lp) = 1
                                'Debug.Print("Value 0 detected, substituted by 1, because 0 is an end-of-sample marker")
                            End If

                            If (program_lp = input_filesize) Then
                                'Debug.Print("Last byte = " & DataToDevice(2 + packet_lp) & " is substituted by 0 (end-of-sample marker)")
                                DataToDevice(2 + packet_lp) = 0
                            End If
                            pgrBar.Value(program_lp)
                        Else
                            DataToDevice(2 + packet_lp) = 0    'fill packet with 0's, technically not really required but it is more ellegant and easier to read if we need to debug it on the receiving end
                        End If
                    Next packet_lp

                    'send the data to the USB device and wait for acknowledge
                    If (SendDataToDevice() And GetDataFromDevice() And DataFromDevice(1) = CMD_FILE_FROM_PC) Then
                        'Debug.Print("Send_PRG_file 'data package' send succesfully")
                    Else
                        MessageBox.Show("Send_WAV_File 'data package' has not received the expected response of the slave device", "Problem during sending of file data", MessageBoxButtons.OK)
                        pgrBar.Dispose()
                        Exit Sub
                    End If
                End While

                Debug.Print("Send_WAV_File has send file succesfully")
                pgrBar.Dispose()
            End Using
        End Using
    End Sub

    'This routine sends the specifications of a file to the USB device, followed by the filedata (if larger then .. bytes data is spread over multiple packets)
    'The filename is truncated/filled with spaces to ... characters
    Public Sub Send_DAT_File(ByVal filepath As String)
        Dim filename As String
        Dim lp As Byte
        Dim input_filesize As UInteger
        Dim filesizeinblocks As Long
        Dim value() As Byte
        Dim packet_lp As Byte
        Dim program_lp As UInteger
        Dim Now As DateTime = DateTime.Now

        filename = System.IO.Path.GetFileName(filepath).ToUpper 'remove the path, leaving only the pure filename (which is exactly what we want), convert also to upper case to make it readable on the C64
        Debug.Print("filename = " & filename & "   filepath=" & filepath)

        'open file and gather data
        Using fs As New FileStream(filepath, FileMode.Open)
            input_filesize = fs.Length
            fs.Position = 0
            Using br As New BinaryReader(fs)
                fs.Position = 0

                'transfer the file details
                '-------------------------
                Dim pgrBar As New frm_ProgressBar
                pgrBar.Init("Copying file to Cassiopei's Flash memory", 0, input_filesize)
                pgrBar.Show()

                'fill the USB buffer with the data
                DataToDevice(0) = 0                         'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
                DataToDevice(1) = CMD_PREPARE_FILE_FROM_PC  'this is the command, which is used in the device to determine the action to be taken on the next request of data
                DataToDevice(2) = FILETYPE_DAT              'save the filetype

                For lp = 0 To 31                            'filename is 32 bytes
                    If lp < filename.Length Then
                        DataToDevice(lp + 3) = AscW(filename(lp))
                    Else
                        DataToDevice(lp + 3) = 32 'fill empty char position with spaces
                    End If
                Next lp


                filesizeinblocks = Calculate_FilesizeSizeInBlocks(input_filesize, PACKET_PAYLOADSIZE_USERFILE)
                value = BitConverter.GetBytes(filesizeinblocks)
                'Debug.Print("size=" & input_filesize & " nextblockaddress=" & value(2).ToString("X2") & "," & value(1).ToString("X2") & "," & value(0).ToString("X2"))
                DataToDevice(35) = value(2)   'filesize (rounded to a 4K boundry) MSB
                DataToDevice(36) = value(1)   '.SB
                DataToDevice(37) = value(0)   'LSB
                DataToDevice(38) = Now.Year \ 100
                DataToDevice(39) = Now.Year Mod 100
                DataToDevice(40) = Now.Month
                DataToDevice(41) = Now.Day
                DataToDevice(42) = Now.Hour
                DataToDevice(43) = Now.Minute
                DataToDevice(44) = &H80 '<<for future use>>
                DataToDevice(45) = &H80 '<<for future use>>
                DataToDevice(46) = &H80 '<<for future use>>

                value = BitConverter.GetBytes(fs.Length)
                DataToDevice(47) = value(2) 'Uncompressed filesize MSB (this value is more accurate then the blocksize value, which is always larger thenthe real filesize)
                DataToDevice(48) = value(1) 'Uncompressed filesize .SB (therefore it makes sense to add this information to both compressed and uncompressed files)
                DataToDevice(49) = value(0) 'Uncompressed filesize LSB

                DataToDevice(50) = &H80 '<<for future use>>

                'send the data to the USB device and wait for acknowledge
                If (SendDataToDevice() And GetDataFromDevice() And DataFromDevice(1) = CMD_PREPARE_FILE_FROM_PC) Then
                    'Debug.Print("Send_PRG_File 'file info package' send succesfully")
                Else
                    MessageBox.Show("Send_DAT_File 'file info package' has not received the expected response of the slave device", "Problem during sending of file details", MessageBoxButtons.OK)
                    pgrBar.Dispose()
                    Exit Sub
                End If

                'transfer the data
                '-----------------

                program_lp = 0
                While program_lp < input_filesize       'copy all the data from the file
                    Application.DoEvents()              'update the GUI!!!
                    DataToDevice(0) = 0                 'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
                    DataToDevice(1) = CMD_FILE_FROM_PC  'this is the command, which is used in the device to determine the action to be taken on the next request of data

                    For packet_lp = 0 To (PACKET_PAYLOADSIZE_USERFILE - 1)
                        If program_lp < input_filesize Then
                            DataToDevice(2 + packet_lp) = br.ReadByte  'read data byte from file and copy to the buffer
                            'Debug.Print(program_lp & " " & packet_lp & " = " & DataToDevice(2 + packet_lp).ToString("X2"))
                            program_lp = program_lp + 1
                            pgrBar.Value(program_lp)
                        Else
                            DataToDevice(2 + packet_lp) = 0    'fill packet with 0's, technically not really required but it is more ellegant and easier to read if we need to debug it on the receiving end
                        End If
                    Next packet_lp

                    'send the data to the USB device and wait for acknowledge
                    If (SendDataToDevice() And GetDataFromDevice() And DataFromDevice(1) = CMD_FILE_FROM_PC) Then
                        'Debug.Print("Send_PRG_file 'data package' send succesfully")
                    Else
                        MessageBox.Show("Send_DAT_File 'data package' has not received the expected response of the slave device", "Problem during sending of file data", MessageBoxButtons.OK)
                        pgrBar.Dispose()
                        Exit Sub
                    End If
                End While

                Debug.Print("Send_DAT_File has send file succesfully")
                pgrBar.Dispose()
            End Using
        End Using
    End Sub

    Public Sub Send_Virtual_PRG_File(ByVal filepath As String)
        Dim input_filesize As UInteger
        Dim low_byte As Byte
        Dim high_byte As Byte
        Dim FirstAddress As UInteger
        Dim LastAddress As UInteger
        Dim packet_lp As Byte
        Dim program_lp As Double
        Dim bytecnt As Integer

        'open file and gather data
        Debug.Print("Transfer of virtual PRG file: " & filepath)
        Using fs As New FileStream(filepath, FileMode.Open)
            input_filesize = fs.Length
            fs.Position = 0

            Using br As New BinaryReader(fs)
                low_byte = br.ReadByte  'read low byte of start address
                high_byte = br.ReadByte  'read high byte of start address

                FirstAddress = (high_byte * 256) + low_byte     'first memory address of program when loaded into C64
                LastAddress = FirstAddress + input_filesize - 2 'last memory address of program when loaded into C64 (filesize-2 because the file used has the first two bytes used for the definition of the LOAD address and is nor really part of the program that is to be transferred)

                DataToDevice(2) = LastAddress Mod 256       'low byte of last memory address of program when loaded into C64
                DataToDevice(3) = LastAddress >> 8          'high byte of last memory address of program when loaded into C64
                DataToDevice(4) = low_byte                  'low byte of start address
                DataToDevice(5) = high_byte                 'high byte of start address
                bytecnt = 6                                 'the first available buffer location where we can store data for the transfer

                'transfer the data from the file
                '-------------------------------
                Dim pgrBar As New frm_ProgressBar
                pgrBar.Init("Copying file directly into the CBM's RAM", FirstAddress, LastAddress)
                pgrBar.Show()
                program_lp = FirstAddress
                While program_lp < LastAddress                      'copy all the data from the file
                    Application.DoEvents()      'update the GUI!!!
                    DataToDevice(0) = 0                             'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
                    DataToDevice(1) = CMD_FILE_FROM_PC_VIRTUALPRGFILE  'command that indicates a "virtual file"

                    For packet_lp = bytecnt To (PACKET_PAYLOADSIZE_VIRTUALFILE + 2) '+2 since we start to count from 1, meaning 0,1 are allready filled and the first available is 2
                        If program_lp < LastAddress Then
                            DataToDevice(packet_lp) = br.ReadByte  'read data byte from file and copy to the buffer
                            'Debug.Print(program_lp & " " & packet_lp & " = " & DataToDevice(2 + packet_lp).ToString("X2"))
                            program_lp = program_lp + 1
                            pgrBar.Value(program_lp)
                        Else
                            DataToDevice(packet_lp) = 0         'fill packet with 0's, technically not really nessecary but it is more ellegant and easier to read if we need to debug it on the receiving end
                        End If
                    Next packet_lp
                    bytecnt = 2                                 'the first available buffer location where we can store data fro the transfer

                    'send the data to the USB device and wait for acknowledge
                    If (SendDataToDevice() And GetDataFromDevice() And DataFromDevice(1) = CMD_FILE_FROM_PC_VIRTUALPRGFILE) Then
                        'Debug.Print("Send_PRG_file 'data package' send succesfully")
                    Else
                        MessageBox.Show("Virtual PRG file 'data package' transfer has not received the expected response of the slave device", "Problem during sending direct load data", MessageBoxButtons.OK)
                        pgrBar.Dispose()
                        Exit Sub
                    End If

                End While

                Debug.Print("Virtual PRG file transfer succesfull")
                pgrBar.Dispose()
            End Using
        End Using
    End Sub

    'this routine may only be called when the data of the TAP file has been loaded into the RAM buffer (using clsTAP.Init_TAP_file)
    Public Function Send_Virtual_TAP_Packet(ByVal counter As UInteger) As UInteger
        Dim packet_lp As Byte

        DataToDevice(0) = 0                                 'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
        DataToDevice(1) = CMD_FILE_FROM_PC_VIRTUALTAPFILE   'command that indicates a "virtual file"
        DataToDevice(2) = frm_Main.clsTAP.Version           'the version info is VERY important for interpretation of TAP files (for the easy of programming we send this value in every packet)

        For packet_lp = 3 To (PACKET_PAYLOADSIZE_VIRTUALFILE + 3) '+3 since we start to count from 1, meaning 0,1,2 are allready filled and the first available is 2
            Try
                DataToDevice(packet_lp) = frm_Main.clsTAP.DataBuffer(counter)  'read data byte from file and copy to the buffer
                counter = counter + 1
                'Debug.Print(counter & "=" & DataToDevice(packet_lp).ToString("X2"))
            Catch ex As Exception
                Debug.Print("Error: during buffer read")
                Send_Virtual_TAP_Packet = False
                Exit Function
            End Try
        Next packet_lp

        'send the data to the USB device and wait for acknowledge
        If (SendDataToDevice() And GetDataFromDevice() And DataFromDevice(1) = CMD_VIRTUALTAPTRANSFERSTATUS) Then
            'Debug.Print("Send_PRG_file 'data package' send succesfully")
            Send_Virtual_TAP_Packet = counter
            buf_Underflow = (DataFromDevice(2) * 256) + DataFromDevice(3)
            'Debug.Print(buf_Underflow)
        Else
            MessageBox.Show("Virtual TAP file 'data package' transfer has not received the expected response of the slave device", "Problem during data transfer", MessageBoxButtons.OK)
            Send_Virtual_TAP_Packet = False
            Exit Function
        End If

    End Function


    'This routine sends data only to the USB device (if larger then .. bytes data is spread over multiple packets)
    'this is usefull for sending large data files (samples for instance) or for copying flash (although this would require a Get_data_file routine as well)
    Public Sub Send_data_File(ByVal filepath As String, ByVal FlashAdr2 As Byte, ByVal FlashAdr1 As Byte, ByVal FlashAdr0 As Byte)
        Dim input_filesize As UInteger
        Dim packet_lp As Byte
        Dim address As Long
        Dim value() As Byte

        'open file and gather data
        Using fs As New FileStream(filepath, FileMode.Open)
            input_filesize = fs.Length
            fs.Position = 0
            Using br As New BinaryReader(fs)
                'transfer the data
                '-----------------
                Dim pgrBar As New frm_ProgressBar
                pgrBar.Init("Copying file to Cassiopei's Flash memory", 0, input_filesize)
                pgrBar.Show()

                address = 0
                While address < input_filesize 'copy all the data from the file
                    value = BitConverter.GetBytes(address)
                    DataToDevice(0) = 0                 'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
                    DataToDevice(1) = CMD_WRITE_DATA_TO_FLASH  'this is the command, which is used in the device to determine the action to be taken on the next request of data
                    DataToDevice(2) = value(2) 'msb of flash address
                    DataToDevice(3) = value(1)
                    DataToDevice(4) = value(0) 'lsb of flash address

                    For packet_lp = 0 To (PACKET_PAYLOADSIZE_DATAFILE - 1)
                        If address < input_filesize Then
                            DataToDevice(5 + packet_lp) = br.ReadByte  'read data byte from file and copy to the buffer
                            address = address + 1                      'increment flash address counter, so that each packet gets the correct start address

                            'Debug.Print("address=" & address)
                            If (address Mod 4096) = 0 Then  'update only on every 4 KByte (if we do it on every byte, then it would slow down this for-next loop significantly)
                                pgrBar.Value(address)
                                Application.DoEvents()      'update the GUI!!!
                            End If
                        Else
                            DataToDevice(5 + packet_lp) = 0    'fill packet with 0's, technically not really nessecary but it is more elegant and easier to read if we need to debug it on the receiving end
                        End If
                    Next packet_lp

                    'send the data to the USB device and wait for acknowledge
                    If (SendDataToDevice() And GetDataFromDevice() And DataFromDevice(1) = CMD_WRITE_DATA_TO_FLASH) Then
                        'Debug.Print("Send_data_file package send succesfully")
                    Else
                        MessageBox.Show("Send_data_file package has not received the expected response of the slave device", "Problem during sending of file", MessageBoxButtons.OK)
                        pgrBar.Dispose()
                        Exit Sub
                    End If
                End While

                Debug.Print("Send_data_File has send file succesfully")
                pgrBar.Dispose()
            End Using
        End Using
    End Sub


    'this routine will scans the filechain. It will mark all the blocks that belong to a file with a special marker value
    'when this routine is done it will have an array holding all the indexes of the orphaned blocks. Blocks that aren't empty but do not belong to a file
    Enum BlockStatus As Integer
        undefined
        used_by_file
        empty
    End Enum

    Public Sub CheckFilechains()
        Const offset As Integer = 2   'the data returned has an offset in the array of 2 bytes
        Const bsize As Integer = 4096   'the number of bytes in a block

        Dim A2 As Byte
        Dim A1 As Byte
        Dim A0 As Byte
        Dim Type As Byte

        Dim block As Integer
        Dim next_block As Integer
        Dim block_arr((FilesystemSize / bsize), 5) As Integer 'we want to store the first 4 bytes of each block in the block array and an extra byte for storing a status flag
        Dim systemfilesize As Integer
        Dim no_file_found As Boolean
        Dim end_of_file As Boolean
        Dim timeout As Integer
        Dim value() As Byte
        Dim Total_of_orphaned_blocks As Integer

        Dim pgrBar As New frm_ProgressBar

        pgrBar.Init("Reading block headers", 0, ((FilesystemSize / bsize) - 1))     'to indicate action, a dummy progressbar is shown with the text "preparing transfer"
        pgrBar.Show()
        For block = 0 To ((FilesystemSize / bsize) - 1)       'read all the block headers (the first 4 bytes of the block) and put them in a huge array (-1 because we start to count from 0)
            value = BitConverter.GetBytes(block * bsize)
            If (Read_32Bytes_From_Flash(value(2), value(1), value(0)) = False) Then Exit Sub
            A2 = DataFromDevice(offset + 0)
            A1 = DataFromDevice(offset + 1)
            A0 = DataFromDevice(offset + 2)
            Type = DataFromDevice(offset + 3)

            block_arr(block, 0) = A2
            block_arr(block, 1) = A1
            block_arr(block, 2) = A0
            block_arr(block, 3) = Type
            block_arr(block, 4) = BlockStatus.undefined 'this flag will later be used to indicated wether or not this block file belongs to a file
            'Debug.Print("Block=" & block & ":" & A2.ToString("X2") & " " & A1.ToString("X2") & " " & A0.ToString("X2") & " " & Type.ToString("X2") & " ")

            pgrBar.Value(block)
            Application.DoEvents()                      'update the GUI!!!
        Next block
        pgrBar.Hide()   'stop showing

        'check if the current block is a systemfile block
        systemfilesize = 0
        If ((block_arr(block, 0) = 0) And (block_arr(block, 1) = 0) And (block_arr(block, 2) = 0) And (block_arr(block, 3) = 1)) Then
            'get the size of the systemfile and mark all blocks that belong to the system file
            If (Read_32Bytes_From_Flash(0, 0, 0) = False) Then Exit Sub
            A2 = DataFromDevice(offset + 36)
            A1 = DataFromDevice(offset + 37)
            A0 = DataFromDevice(offset + 38)
            systemfilesize = (A2 * 256 * 256) + (A1 * 256) + A0
            Debug.Print("Systemfile is=" & systemfilesize)

            'mark all the blocks used by the systemfile, so that we know these blocks contain valid adat and belong to a file (the systemfile)
            For block = 0 To systemfilesize
                block_arr(block, 4) = BlockStatus.used_by_file
            Next block
        End If

        'search empty blocks and mark these as empty (by doing this here we do not have to check if the processed block is an empty block during scanning the filechain)
        pgrBar.Init("Identifying empty blocks", 0, ((FilesystemSize / bsize) - 1))     'to indicate action, a dummy progressbar is shown with the text "preparing transfer"
        pgrBar.Show()
        For block = systemfilesize To ((FilesystemSize / bsize) - 1) '-1 because we start to count from 0
            If ((block_arr(block, 0) = &HFF) And (block_arr(block, 1) = &HFF) And (block_arr(block, 2) = &HFF) And (block_arr(block, 3) = &HFF)) Then
                block_arr(block, 4) = BlockStatus.empty
            End If
            pgrBar.Value(block)
            Application.DoEvents()                      'update the GUI!!!
        Next block

        pgrBar.Hide()   'stop showing

        'process the remaining blocks
        'search for a file then scan it's chain
        'search for the next file and scan it's chain
        'search for...
        'when there is no more file found then we are done and the blocks that remain and are marked undefined are considered to be orphaned and need to be fixed
        pgrBar.Init("Scanning file chain(s)", 0, ((FilesystemSize / bsize) - 1))     'to indicate action, a dummy progressbar is shown with the text "preparing transfer"
        pgrBar.Show()
        no_file_found = False
        Do Until (no_file_found = True) 'keep looping until there are no more files found
            no_file_found = True
            For block = systemfilesize To ((FilesystemSize / bsize) - 1) '-1 because we start to count from 0
                If ((block_arr(block, 4) = BlockStatus.undefined) And ((block_arr(block, 3) And &HF) > 0)) Then
                    no_file_found = False 'make sure we loop again after we scanned the chain of this file we just found
                    next_block = block 'by pretending that the current block is already a next block we can keep the code simpler

                    end_of_file = False
                    timeout = (FilesystemSize / bsize)
                    Do Until (end_of_file = True) '(unless the file has ended) go to the next block of the file                     
                        timeout = timeout - 1
                        If timeout = 0 Then
                            MsgBox("The filesystem contains a file that has no end, please erase the entire filesystem")
                            Exit Sub
                        End If

                        block_arr(next_block, 4) = BlockStatus.used_by_file  'no matter how this may turn out, we must mark this block as used by a file
                        'Debug.Print("Block " & next_block & " (" & next_block.ToString("X6") & ") is marked as used")
                        'Debug.Print("next_block=" & next_block & ":" & block_arr(next_block, 0).ToString("X2") & " " & block_arr(next_block, 1).ToString("X2") & " " & block_arr(next_block, 2).ToString("X2"))
                        If ((block_arr(next_block, 0) = &HFF) And (block_arr(next_block, 1) = &HFF) And (block_arr(next_block, 2) = &HFF)) Then 'check if the block we've just read is also the last block of this file
                            end_of_file = True  'yes it was the last block
                        Else
                            'nope, it wasn't the last block, read the next block belonging to this file
                            next_block = ((block_arr(next_block, 0) * 256 * 256) + (block_arr(next_block, 1) * 256) + block_arr(next_block, 2)) / bsize 'determine the next block
                        End If
                    Loop

                End If
                pgrBar.Value(block)
                Application.DoEvents()                      'update the GUI!!!
            Next block
        Loop
        pgrBar.Hide()   'stop showing

        'show the results
        Total_of_orphaned_blocks = 0
        For lp = 0 To ((FilesystemSize / bsize) - 1)  '-1 because we start to count from 0
            If (block_arr(lp, 4) = BlockStatus.undefined) Then
                block = lp * bsize
                Debug.Print("Block " & lp & " (" & block.ToString("X6") & ") is an orphaned block")
                Total_of_orphaned_blocks = Total_of_orphaned_blocks + 1
            End If
        Next lp

        If (Total_of_orphaned_blocks > 0) Then
            If MessageBox.Show("Scan completed, " & Total_of_orphaned_blocks & " orphaned blocks found." & vbCrLf &
                               "Do you want to solve the problem and erase these blocks." & vbCrLf &
                               "This does not affect your currently installed files",
                               "Scan results", MessageBoxButtons.YesNo, MessageBoxIcon.Question) = DialogResult.Yes Then
                'erase the orphaned blocks
                For lp = 0 To ((FilesystemSize / bsize) - 1)  '-1 because we start to count from 0
                    If (block_arr(lp, 4) = BlockStatus.undefined) Then                      
                        DataToDevice(0) = 0                         'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
                        DataToDevice(1) = CMD_ERASE_BLOCK           'this is the command, which is used in the device to determine the action to be taken on the next request of data
                        block = lp * bsize                          'calculate the real block address
                        value = BitConverter.GetBytes(block)        'convert it into 3 bytes (MSB, .SB, LSB)
                        DataToDevice(2) = value(2)  'A2 (MSB of block address)
                        DataToDevice(3) = value(1)  'A1 (.SB of block address)
                        If (SendDataToDevice() And GetDataFromDevice() And DataFromDevice(1) <> CMD_ERASE_BLOCK) Then 'send the data to the USB device and wait for acknowledge
                            MessageBox.Show("Erase block command has not received the expected response of the slave device", "Aborting operation", MessageBoxButtons.OK)
                            Exit Sub
                        End If
                    End If
                Next lp

            Else
                MsgBox("Filesystem has not been altered, the problem will remain!")
            End If
        End If

        pgrBar.Dispose()    'progressbar is no longer required
    End Sub

    Public Sub EraseAllFlash()
        'fill the USB buffer with the data
        DataToDevice(0) = 0                         'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
        DataToDevice(1) = CMD_ERASE_ALL_FLASH       'this is the command, which is used in the device to determine the action to be taken on the next request of data

        'send the data to the USB device and wait for acknowledge
        If (SendDataToDevice() And GetDataFromDevice() And DataFromDevice(1) = CMD_ERASE_ALL_FLASH) Then
            Debug.Print("Erase all flash request send succesfully")
        Else
            MessageBox.Show("Erase all flash command has not received the expected response of the slave device", "Problem during erase all flash request", MessageBoxButtons.OK)
            Exit Sub
        End If
    End Sub


    Public Sub Simulate_Button_Play()
        'fill the USB buffer with the data
        DataToDevice(0) = 0                         'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
        DataToDevice(1) = CMD_SIMULATE_BUTTON_PLAY  'this is the command, which is used in the device to determine the action to be taken on the next request of data

        'send the data to the USB device and wait for acknowledge
        If (SendDataToDevice() And GetDataFromDevice() And DataFromDevice(1) = CMD_SIMULATE_BUTTON_PLAY) Then
            'Debug.Print("Button simulate request")
        Else
            MessageBox.Show("Could not simulate play-button action", "Problem simulating play-button action", MessageBoxButtons.OK)
            Exit Sub
        End If
    End Sub


    'Provides a central mechanism for exception handling. Displays a message box that describes the exception.
    Shared Sub DisplayException(ByVal moduleName As String, ByVal e As Exception)
        Dim message As String

        message = "Exception: " & e.Message & ControlChars.CrLf & "Module: " & moduleName & ControlChars.CrLf & "Method: " & e.TargetSite.Name
        MessageBox.Show(message, "Unexpected Exception", MessageBoxButtons.OK)
    End Sub


    Public Function GetVersionInfo() As String
        DataToDevice(0) = 0                 'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
        DataToDevice(1) = CMD_VERSIONINFO   'this is the command, which is used in the device to determine the action to be taken on the next request of data

        'Dim lp As Integer

        'send the data to the USB device and wait for acknowledge
        If (SendDataToDevice() And GetDataFromDevice() And DataFromDevice(1) = CMD_VERSIONINFO) Then
            GetVersionInfo = "20" & DataFromDevice(2).ToString("D2") & DataFromDevice(3).ToString("D2") & DataFromDevice(4).ToString("D2")
            'For lp = 2 To 15
            '    Debug.Print(DataFromDevice(lp))
            'Next
        Else
            GetVersionInfo = "unknown"
        End If
    End Function

    'this function returns -1 when no (valid) data could be received
    Public Function TAPstatus() As Long
        DataToDevice(0) = 0                 'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
        DataToDevice(1) = CMD_STATUS        'this is the command, which is used in the device to determine the action to be taken on the next request of data


        'send the data to the USB device and wait for acknowledge
        If (SendDataToDevice() And GetDataFromDevice() And DataFromDevice(1) = CMD_STATUS) Then
            'reserved = DataFromDevice(2) 'this byte is not yet defined
            TAPstatus = (DataFromDevice(3) * 256 * 256) + (DataFromDevice(4) * 256) + DataFromDevice(5)
        Else
            TAPstatus = -1
        End If

        'Debug.Print("Motor status       = " & DataFromDevice(6).ToString)
        'Debug.Print("Current file index = " & DataFromDevice(7).ToString)
        'Debug.Print("Current file type  = " & DataFromDevice(8).ToString)
    End Function

    Public Sub TAPplay()
        DataToDevice(0) = 0                 'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
        DataToDevice(1) = CMD_TAP_PLAY      'this is the command, which is used in the device to determine the action to be taken on the next request of data
        SendDataToDevice()                  'send the data to the USB device
    End Sub

    Public Sub TAPstop()
        DataToDevice(0) = 0                 'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
        DataToDevice(1) = CMD_TAP_STOP      'this is the command, which is used in the device to determine the action to be taken on the next request of data
        SendDataToDevice()                  'send the data to the USB device
    End Sub

    Public Sub TAPposition(ByVal pos As Long)
        Dim value() As Byte

        DataToDevice(0) = 0                 'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
        DataToDevice(1) = CMD_TAP_POSITION   'this is the command, which is used in the device to determine the action to be taken on the next request of data
        value = BitConverter.GetBytes(pos)
        DataToDevice(2) = value(2)          'offset in file (a.k.a. position) MSB
        DataToDevice(3) = value(1)          '.SB
        DataToDevice(4) = value(0)          'LSB

        'Debug.Print(pos & " " & value(2) & " " & value(1) & " " & value(0))
        SendDataToDevice()                  'send the data to the USB device
    End Sub

    'send a text string to the display connected to the I2C bus of the Cassiopei
    Public Function Display(ByVal x As Byte, ByVal y As Byte, ByVal text As String) As Boolean
        Dim lp As Integer
        Dim chrcnt As Integer
        Dim data As Byte

        DataToDevice(0) = 0                 'this is the report ID, in a device with only one (out endpoint (data going out of the computer into the device)), this should be 0 (as that device would have output endpoint number 0
        DataToDevice(1) = CMD_DISPLAY       'this is the command, which is used in the device to determine the action to be taken on the next request of data
        DataToDevice(2) = x                 'the X coordinate of the text on the display
        DataToDevice(3) = y                 'the Y coordinate of the text on the display

        chrcnt = text.Length
        If (chrcnt > 40) Then   'limit the max amount of characters
            chrcnt = 40
        End If

        For lp = 0 To chrcnt - 1
            data = AscW(text(lp))
            DataToDevice(4 + lp) = data
        Next lp
        DataToDevice(4 + lp) = 0    'a safety end-of-string marker

        'send the data to the USB device and wait for acknowledge
        If (SendDataToDevice() And GetDataFromDevice() And DataFromDevice(1) = CMD_DISPLAY) Then
            Display = True
        Else
            Display = False
            MessageBox.Show("The device does not respond as expected." & vbCrLf &
                            "If you've just connected or resetted the Cassiopei" & vbCrLf &
                            "then please wait 10 seconds then try again. If this" & vbCrLf &
                            "persists, reset both the Cassiopei and the CBM" & vbCrLf &
                            "computer and then try again.", "Cassiopei does not respond", MessageBoxButtons.OK)
        End If

    End Function

    'clear the specified line of the display connected to the I2C bus of the Cassiopei (by writing spaces)
    Public Sub DisplayClearline(ByVal x As Byte, ByVal y As Byte)
        Display(x, y, "                     ") '21 spaces are required to clear the line on the display
    End Sub


End Class
