﻿
Imports System.IO

Public Class cls_TAP_file

    Private clsCompress As New cls_Compress  'we use this class to make .TAP file smaller
    '-----------------------------------------------------------

    Public Const MaxTapFileSize As Double = 10485760 'max tape file size is limitted to 10MBytes (thats a very big file !!!)

    '----------------------------------------------------------------------------------------------------------------------------

    Public MagicWord As String
    Public Version As String
    Public Machine As String
    Public VideoSystem As String
    Public DataBuffer(MaxTapFileSize) As Byte
    Public Filesize As Double                       'size of the file
    Public Datasize As Double                       'size of the data
    Public Compressed As Boolean                    'flag indicates wether or not compression was succesfull
    Public CompressedFilename As String
    Public CompressedFilesize As Long
    Public CompressionFactor As String
    Public Escapecode As Byte

    '----------------------------------------------------------------------------------------------------------------------------

    'this function will buffer the data of the TAP file into the PC's RAM, for the easiest and fastest method of access
    Public Function Init_TAP_file(ByVal filepath As String, ByVal compress As Boolean)

        Dim Version_byte As Byte
        Dim Machine_byte As Byte
        Dim VideoSystem_byte As Byte
        Dim Dummy As Byte
        Dim DataPntr As Double
        Dim msgboxstring As String

        'attempt to compress the file
        If (compress = True) Then
            If (clsCompress.Compress_TAP(filepath) = True) Then
                Compressed = True
                CompressedFilename = clsCompress.CompressedFilename
                CompressedFilesize = clsCompress.CompressedFilesize
                CompressionFactor = clsCompress.CompressionFactor
                Escapecode = clsCompress.Escapecode
            End If
        Else
            Compressed = False
        End If

        'open file and gather data
        Using fs As New FileStream(filepath, FileMode.Open)
            Filesize = fs.Length
            Datasize = Filesize - 16           'the size of the file without the filedetails
            fs.Position = 0
            Using br As New BinaryReader(fs)

                MagicWord = ""
                For lp = 0 To 11                    'magic word is 12 bytes
                    MagicWord = MagicWord + ASCII_table(br.ReadByte)
                Next lp
                Version_byte = br.ReadByte          'version is 1 byte
                Machine_byte = br.ReadByte          'machine is 1 byte
                VideoSystem_byte = br.ReadByte      'system is 1 byte
                Dummy = br.ReadByte                 'reserved for future use


                Select Case (Version_byte)
                    Case 0
                        Version = "0"

                    Case 1
                        Version = "1"

                    Case Else
                        Version = "0x" & Version_byte.ToString("X2") & " = undefined"
                End Select


                Select Case (VideoSystem_byte)
                    Case 0
                        VideoSystem = "PAL"

                    Case 1
                        VideoSystem = "NTSC"

                    Case Else
                        VideoSystem = "0x" & VideoSystem_byte.ToString("X2") & " = undefined"
                End Select


                Select Case (Machine_byte)
                    Case 0
                        Machine = "C64"

                    Case 1
                        Machine = "VIC20"

                    Case 2
                        Machine = "C16/Plus4"

                    Case Else
                        Machine = "0x" & Machine_byte.ToString("X2") & " = undefined"
                End Select

                msgboxstring = ""
                msgboxstring = msgboxstring & "Magic word" & vbTab & ": " & MagicWord & vbCrLf
                msgboxstring = msgboxstring & "TAP file version" & vbTab & ": " & Version & vbCrLf
                msgboxstring = msgboxstring & "Machine      " & vbTab & ": " & Machine & vbCrLf
                msgboxstring = msgboxstring & "Video system " & vbTab & ": " & VideoSystem & vbCrLf & vbCrLf
                msgboxstring = msgboxstring & "TAP file size   " & vbTab & ": " & Filesize & " bytes" & vbCrLf
                msgboxstring = msgboxstring & "Actual data size" & vbTab & ": " & Datasize & " bytes" & vbCrLf

                If (Compressed = True) Then
                    msgboxstring = msgboxstring & "Compressed size " & vbTab & ": " & CompressedFilesize & " bytes" & vbCrLf
                    msgboxstring = msgboxstring & "Size reduction  " & vbTab & ": " & CompressionFactor & vbCrLf
                End If

                MessageBox.Show(msgboxstring, "TAP file info", MessageBoxButtons.OK)    'show a message box with information about the TAP file

                If (Filesize > MaxTapFileSize) Then
                    MessageBox.Show("TAP file request denied !" & vbCrLf & "Max filesize (" & MaxTapFileSize & " bytes) exceeded.", "TAP not supported", MessageBoxButtons.OK)
                    Init_TAP_file = False
                    Exit Function
                End If

                If (MagicWord <> "C64-TAPE-RAW") Or (Val(Version) > 1) Then
                    MessageBox.Show("TAP file request denied !" & vbCrLf & "Contact the distributor of this program for more information", "TAP not supported", MessageBoxButtons.OK)
                    Init_TAP_file = False
                    Exit Function
                End If


                Dim pgrBar As New frm_ProgressBar
                pgrBar.Init("Preparing transfer", 0, Datasize)
                pgrBar.Show()

                For DataPntr = 0 To ((Filesize - 1) - 16)   '-1 because the filesize is allways 1 bigger then the address of the last byte in the file (because the file starts to count a 0). Copy all the data from the file (the first ... bytes of the file contain no data but file info and is allready read)
                    If (DataPntr Mod 1024 = 0) Then pgrBar.Value(DataPntr) 'update progressbar every kilobyte

                    Try
                        DataBuffer(DataPntr) = br.ReadByte  'read data byte from file and copy to the buffer

                    Catch ex As Exception
                        MsgBox("Error: problem filling buffer")
                        Init_TAP_file = False
                        pgrBar.Dispose()        'progressbar no longer needed
                        Exit Function
                    End Try

                    Application.DoEvents()      'update the GUI!!!
                Next DataPntr
                Init_TAP_file = True
                pgrBar.Dispose()                'progressbar no longer needed
            End Using
        End Using
    End Function


End Class
